<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('spotlights', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->text('content');
//            offer_id
            $table->foreignId('offer_id')->nullable()->constrained()->onDelete('set null');
            $table->enum('media_type', ['image', 'video', 'mixed'])->nullable();
            $table->json('media_urls')->nullable();
            $table->string('location')->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected', 'flagged'])->default('pending');
            $table->enum('moderation_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->foreignId('moderated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('moderated_at')->nullable();
            $table->text('moderation_notes')->nullable();
            $table->integer('likes_count')->default(0);
            $table->integer('comments_count')->default(0);
            $table->integer('shares_count')->default(0);
            $table->integer('view_count')->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['user_id', 'status']);
            $table->index('moderation_status');
            $table->index('created_at');
        });

        Schema::create('spotlight_likes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('spotlight_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            $table->unique(['spotlight_id', 'user_id']);
        });

        Schema::create('spotlight_comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('spotlight_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('parent_id')->nullable()->constrained('spotlight_comments')->onDelete('cascade');
            $table->text('comment');
            $table->enum('status', ['active', 'hidden', 'flagged'])->default('active');
            $table->timestamps();
            $table->softDeletes();

            $table->index(['spotlight_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('spotlight_comments');
        Schema::dropIfExists('spotlight_likes');
        Schema::dropIfExists('spotlights');
    }
};
