<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add stripe_customer_id to users table
        if (!Schema::hasColumn('users', 'stripe_customer_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('stripe_customer_id')->nullable()->after('fcm_token');
                $table->string('paypal_customer_id')->nullable()->after('stripe_customer_id');
            });
        }

        // Add stripe_subscription_id to subscriptions table
        if (!Schema::hasColumn('subscriptions', 'stripe_subscription_id')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                $table->string('stripe_subscription_id')->nullable()->after('subscription_plan_id');
                $table->string('paypal_subscription_id')->nullable()->after('stripe_subscription_id');
            });
        }

        // Add type column to payments table if not exists
        if (!Schema::hasColumn('payments', 'type')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->string('type')->default('subscription')->after('business_id');
            });
        }

        // Add billing_interval to subscription_plans if not exists
        if (!Schema::hasColumn('subscription_plans', 'billing_interval')) {
            Schema::table('subscription_plans', function (Blueprint $table) {
                $table->string('billing_interval')->default('month')->after('duration_days');
                $table->integer('trial_days')->default(0)->after('billing_interval');
                $table->integer('max_photos')->default(10)->after('max_staff');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('users', 'stripe_customer_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn(['stripe_customer_id', 'paypal_customer_id']);
            });
        }

        if (Schema::hasColumn('subscriptions', 'stripe_subscription_id')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                $table->dropColumn(['stripe_subscription_id', 'paypal_subscription_id']);
            });
        }

        if (Schema::hasColumn('payments', 'type')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropColumn('type');
            });
        }

        if (Schema::hasColumn('subscription_plans', 'billing_interval')) {
            Schema::table('subscription_plans', function (Blueprint $table) {
                $table->dropColumn(['billing_interval', 'trial_days', 'max_photos', 'order']);
            });
        }
    }
};
