<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add guard_name to permissions if not exists
        if (Schema::hasTable('permissions') && !Schema::hasColumn('permissions', 'guard_name')) {
            Schema::table('permissions', function (Blueprint $table) {
                $table->string('guard_name')->default('web')->after('id');
                $table->index('guard_name');
            });
        }

        // Add guard_name to roles if not exists
        if (Schema::hasTable('roles') && !Schema::hasColumn('roles', 'guard_name')) {
            Schema::table('roles', function (Blueprint $table) {
                $table->string('guard_name')->default('web')->after('id');
                $table->index('guard_name');
            });
        }

        // Rename role_permission to role_has_permissions if needed
        if (Schema::hasTable('role_permission') && !Schema::hasTable('role_has_permissions')) {
            Schema::rename('role_permission', 'role_has_permissions');
        }

        // Add guard_name to role_has_permissions if not exists
        if (Schema::hasTable('role_has_permissions') && !Schema::hasColumn('role_has_permissions', 'guard_name')) {
            Schema::table('role_has_permissions', function (Blueprint $table) {
                $table->string('guard_name')->default('web')->after('id');
                $table->index('guard_name');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove guard_name columns
        if (Schema::hasTable('role_has_permissions') && Schema::hasColumn('role_has_permissions', 'guard_name')) {
            Schema::table('role_has_permissions', function (Blueprint $table) {
                $table->dropIndex(['guard_name']);
                $table->dropColumn('guard_name');
            });
        }

        if (Schema::hasTable('roles') && Schema::hasColumn('roles', 'guard_name')) {
            Schema::table('roles', function (Blueprint $table) {
                $table->dropIndex(['guard_name']);
                $table->dropColumn('guard_name');
            });
        }

        if (Schema::hasTable('permissions') && Schema::hasColumn('permissions', 'guard_name')) {
            Schema::table('permissions', function (Blueprint $table) {
                $table->dropIndex(['guard_name']);
                $table->dropColumn('guard_name');
            });
        }

        // Rename back role_has_permissions to role_permission
        if (Schema::hasTable('role_has_permissions')) {
            Schema::rename('role_has_permissions', 'role_permission');
        }
    }
};

