<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if messages table exists
        if (Schema::hasTable('messages')) {
            // Check if chat_id column already exists
            if (!Schema::hasColumn('messages', 'chat_id')) {
                Schema::table('messages', function (Blueprint $table) {
                    // Add the chat_id foreign key
                    $table->foreignId('chat_id')
                        ->after('id')
                        ->constrained('chats')
                        ->onDelete('cascade');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('messages') && Schema::hasColumn('messages', 'chat_id')) {
            Schema::table('messages', function (Blueprint $table) {
                $table->dropForeignKey(['chat_id']);
                $table->dropColumn('chat_id');
            });
        }
    }
};

