<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('businesses', function (Blueprint $table) {
            // Add field to store rejection checklist
            $table->json('rejection_checklist')->nullable()->after('verification_notes');
            // Track rejection reason
            $table->text('rejection_reason')->nullable()->after('rejection_checklist');
            // Allow resubmission
            $table->integer('verification_attempts')->default(0)->after('rejection_reason');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('businesses', function (Blueprint $table) {
            $table->dropColumn(['rejection_checklist', 'rejection_reason', 'verification_attempts']);
        });
    }
};

