<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add invitation_token column if it doesn't exist
        if (!Schema::hasColumn('business_staff', 'invitation_token')) {
            Schema::table('business_staff', function (Blueprint $table) {
                $table->string('invitation_token')->nullable()->unique()->after('joined_at');
                $table->index('invitation_token');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('business_staff', 'invitation_token')) {
            Schema::table('business_staff', function (Blueprint $table) {
                $table->dropIndex(['invitation_token']);
                $table->dropColumn('invitation_token');
            });
        }
    }
};

