<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('venues', function (Blueprint $table) {
            // Add fields to store rejection information
            $table->text('rejection_reason')->nullable()->after('total_reviews');
            $table->json('rejection_checklist')->nullable()->after('rejection_reason');
            $table->integer('verification_attempts')->default(0)->after('rejection_checklist');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('venues', function (Blueprint $table) {
            $table->dropColumn(['rejection_reason', 'rejection_checklist', 'verification_attempts']);
        });
    }
};

