<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add content column to messages table if it doesn't exist
        if (Schema::hasTable('messages')) {
            if (!Schema::hasColumn('messages', 'content')) {
                Schema::table('messages', function (Blueprint $table) {
                    $table->longText('content')->after('sender_id');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('messages') && Schema::hasColumn('messages', 'content')) {
            Schema::table('messages', function (Blueprint $table) {
                $table->dropColumn('content');
            });
        }
    }
};

