<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Doctrine\DBAL\Types\Type;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add missing columns to messages table
        if (Schema::hasTable('messages')) {
            // Register custom types if needed
            if (!Type::hasType('enum')) {
                Type::addType('enum', 'Doctrine\DBAL\Types\StringType');
            }

            Schema::table('messages', function (Blueprint $table) {
                // Add content column if it doesn't exist
                if (!Schema::hasColumn('messages', 'content')) {
                    $table->longText('content')->nullable()->after('sender_id');
                }

                // Make message column nullable if it exists (legacy column)
                if (Schema::hasColumn('messages', 'message')) {
                    try {
                        $table->longText('message')->nullable()->change();
                    } catch (\Exception $e) {
                        // Column might already be nullable
                    }
                }

                // Make receiver_id nullable if it exists
                if (Schema::hasColumn('messages', 'receiver_id')) {
                    try {
                        $table->unsignedBigInteger('receiver_id')->nullable()->change();
                    } catch (\Exception $e) {
                        // Column might already be nullable
                    }
                }

                // Add message_type column if it doesn't exist
                if (!Schema::hasColumn('messages', 'message_type')) {
                    $table->string('message_type')->default('text')->after('content');
                }

                // Add metadata column if it doesn't exist
                if (!Schema::hasColumn('messages', 'metadata')) {
                    $table->json('metadata')->nullable()->after('message_type');
                }

                // Add is_edited column if it doesn't exist
                if (!Schema::hasColumn('messages', 'is_edited')) {
                    $table->boolean('is_edited')->default(false)->after('metadata');
                }

                // Add edited_at column if it doesn't exist
                if (!Schema::hasColumn('messages', 'edited_at')) {
                    $table->timestamp('edited_at')->nullable()->after('is_edited');
                }

                // Add is_deleted column if it doesn't exist
                if (!Schema::hasColumn('messages', 'is_deleted')) {
                    $table->boolean('is_deleted')->default(false)->after('edited_at');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('messages')) {
            Schema::table('messages', function (Blueprint $table) {
                // Drop columns in reverse order
                $columns = [];

                if (Schema::hasColumn('messages', 'is_deleted')) {
                    $columns[] = 'is_deleted';
                }
                if (Schema::hasColumn('messages', 'edited_at')) {
                    $columns[] = 'edited_at';
                }
                if (Schema::hasColumn('messages', 'is_edited')) {
                    $columns[] = 'is_edited';
                }
                if (Schema::hasColumn('messages', 'metadata')) {
                    $columns[] = 'metadata';
                }
                if (Schema::hasColumn('messages', 'message_type')) {
                    $columns[] = 'message_type';
                }
                if (Schema::hasColumn('messages', 'content')) {
                    $columns[] = 'content';
                }

                if (!empty($columns)) {
                    $table->dropColumn($columns);
                }
            });
        }
    }
};



