<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if duration_days exists and add default if needed
        if (Schema::hasTable('subscription_plans')) {
            Schema::table('subscription_plans', function (Blueprint $table) {
                // Make sure duration_days column has a default value
                DB::statement('ALTER TABLE subscription_plans MODIFY duration_days INT DEFAULT 30');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('subscription_plans')) {
            Schema::table('subscription_plans', function (Blueprint $table) {
                DB::statement('ALTER TABLE subscription_plans MODIFY duration_days INT NOT NULL');
            });
        }
    }
};

