<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('marketing_campaigns', function (Blueprint $table) {
            // Add missing columns if they don't exist
            if (!Schema::hasColumn('marketing_campaigns', 'approved_by')) {
                $table->unsignedBigInteger('approved_by')->nullable()->after('status');
            }

            if (!Schema::hasColumn('marketing_campaigns', 'approved_at')) {
                $table->timestamp('approved_at')->nullable()->after('approved_by');
            }

            if (!Schema::hasColumn('marketing_campaigns', 'rejection_reason')) {
                $table->text('rejection_reason')->nullable()->after('approved_at');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('marketing_campaigns', function (Blueprint $table) {
            if (Schema::hasColumn('marketing_campaigns', 'approved_by')) {
                $table->dropColumn('approved_by');
            }
            if (Schema::hasColumn('marketing_campaigns', 'approved_at')) {
                $table->dropColumn('approved_at');
            }
            if (Schema::hasColumn('marketing_campaigns', 'rejection_reason')) {
                $table->dropColumn('rejection_reason');
            }
        });
    }
};

