<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscription_plans', function (Blueprint $table) {
            // Add new columns to subscription_plans if they don't exist
            if (!Schema::hasColumn('subscription_plans', 'tier')) {
                $table->string('tier')->nullable()->after('type');
            }

            if (!Schema::hasColumn('subscription_plans', 'user_type')) {
                $table->enum('user_type', ['business', 'user', 'marketing'])->after('type')->nullable();
            }

            // User-specific features
            if (!Schema::hasColumn('subscription_plans', 'max_favorites')) {
                $table->integer('max_favorites')->default(5)->after('max_staff');
            }

            if (!Schema::hasColumn('subscription_plans', 'max_redemptions_per_month')) {
                $table->integer('max_redemptions_per_month')->nullable()->after('max_favorites');
            }

            if (!Schema::hasColumn('subscription_plans', 'max_reviews_per_month')) {
                $table->integer('max_reviews_per_month')->nullable()->after('max_redemptions_per_month');
            }

            if (!Schema::hasColumn('subscription_plans', 'cashback_percentage')) {
                $table->decimal('cashback_percentage', 5, 2)->default(0)->after('max_reviews_per_month');
            }

            if (!Schema::hasColumn('subscription_plans', 'loyalty_points_multiplier')) {
                $table->integer('loyalty_points_multiplier')->default(1)->after('cashback_percentage');
            }

            if (!Schema::hasColumn('subscription_plans', 'ad_free')) {
                $table->boolean('ad_free')->default(false)->after('loyalty_points_multiplier');
            }

            if (!Schema::hasColumn('subscription_plans', 'early_access_days')) {
                $table->integer('early_access_days')->default(0)->after('ad_free');
            }

            if (!Schema::hasColumn('subscription_plans', 'birthday_reward')) {
                $table->boolean('birthday_reward')->default(false)->after('early_access_days');
            }

            if (!Schema::hasColumn('subscription_plans', 'vip_support')) {
                $table->boolean('vip_support')->default(false)->after('birthday_reward');
            }

            // Marketing-specific features
            if (!Schema::hasColumn('subscription_plans', 'max_banners')) {
                $table->integer('max_banners')->default(1)->after('vip_support');
            }

            if (!Schema::hasColumn('subscription_plans', 'max_impressions')) {
                $table->integer('max_impressions')->default(0)->after('max_banners');
            }

            if (!Schema::hasColumn('subscription_plans', 'ab_testing_enabled')) {
                $table->boolean('ab_testing_enabled')->default(false)->after('max_impressions');
            }

            if (!Schema::hasColumn('subscription_plans', 'retargeting_enabled')) {
                $table->boolean('retargeting_enabled')->default(false)->after('ab_testing_enabled');
            }

            if (!Schema::hasColumn('subscription_plans', 'audience_insights')) {
                $table->boolean('audience_insights')->default(false)->after('retargeting_enabled');
            }

            if (!Schema::hasColumn('subscription_plans', 'dedicated_support')) {
                $table->boolean('dedicated_support')->default(false)->after('audience_insights');
            }

            // Campaign limit
            if (!Schema::hasColumn('subscription_plans', 'monthly_campaigns')) {
                $table->integer('monthly_campaigns')->nullable()->after('dedicated_support');
            }

            // Storage
            if (!Schema::hasColumn('subscription_plans', 'storage_gb')) {
                $table->integer('storage_gb')->default(1)->after('monthly_campaigns');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscription_plans', function (Blueprint $table) {
            $columns = [
                'tier',
                'user_type',
                'max_favorites',
                'max_redemptions_per_month',
                'max_reviews_per_month',
                'cashback_percentage',
                'loyalty_points_multiplier',
                'ad_free',
                'early_access_days',
                'birthday_reward',
                'vip_support',
                'max_banners',
                'max_impressions',
                'ab_testing_enabled',
                'retargeting_enabled',
                'audience_insights',
                'dedicated_support',
                'monthly_campaigns',
                'storage_gb'
            ];

            foreach ($columns as $column) {
                if (Schema::hasColumn('subscription_plans', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};

