<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('marketing_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('business_id')->constrained()->onDelete('cascade');
            $table->foreignId('subscription_plan_id')->constrained('subscription_plans')->onDelete('cascade');

            $table->enum('status', ['trial', 'active', 'paused', 'cancelled'])->default('active');
            $table->date('start_date');
            $table->date('end_date');
            $table->date('trial_end_date')->nullable();

            $table->boolean('auto_renew')->default(true);
            $table->string('payment_method')->nullable(); // free, stripe, paypal, etc.
            $table->date('next_billing_date')->nullable();

            $table->timestamp('cancelled_at')->nullable();
            $table->text('cancellation_reason')->nullable();

            $table->json('usage')->nullable(); // Track usage: campaigns, impressions, clicks, etc.

            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index(['business_id', 'status']);
            $table->index(['status', 'end_date']);
            $table->index('subscription_plan_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('marketing_subscriptions');
    }
};

