<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class AdminPermissionsSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // Main
            ['name' => 'view-dashboard', 'display_name' => 'View Dashboard', 'group' => 'dashboard', 'description' => 'Access to admin dashboard'],
            ['name' => 'view-analytics', 'display_name' => 'View Analytics', 'group' => 'analytics', 'description' => 'View analytics and statistics'],

            // Management
            ['name' => 'manage-users', 'display_name' => 'Manage Users', 'group' => 'users', 'description' => 'Create, view, edit, and delete users'],
            ['name' => 'view-users', 'display_name' => 'View Users', 'group' => 'users', 'description' => 'View user list and details'],
            ['name' => 'create-users', 'display_name' => 'Create Users', 'group' => 'users', 'description' => 'Create new users'],
            ['name' => 'edit-users', 'display_name' => 'Edit Users', 'group' => 'users', 'description' => 'Edit user information'],
            ['name' => 'delete-users', 'display_name' => 'Delete Users', 'group' => 'users', 'description' => 'Delete users'],

            ['name' => 'manage-businesses', 'display_name' => 'Manage Businesses', 'group' => 'businesses', 'description' => 'Full access to business management'],
            ['name' => 'view-businesses', 'display_name' => 'View Businesses', 'group' => 'businesses', 'description' => 'View business list and details'],
            ['name' => 'verify-businesses', 'display_name' => 'Verify Businesses', 'group' => 'businesses', 'description' => 'Approve or reject business verification'],
            ['name' => 'edit-businesses', 'display_name' => 'Edit Businesses', 'group' => 'businesses', 'description' => 'Edit business information'],
            ['name' => 'delete-businesses', 'display_name' => 'Delete Businesses', 'group' => 'businesses', 'description' => 'Delete businesses'],

            ['name' => 'manage-venues', 'display_name' => 'Manage Venues', 'group' => 'venues', 'description' => 'Full access to venue management'],
            ['name' => 'view-venues', 'display_name' => 'View Venues', 'group' => 'venues', 'description' => 'View venue list and details'],
            ['name' => 'edit-venues', 'display_name' => 'Edit Venues', 'group' => 'venues', 'description' => 'Edit venue information'],
            ['name' => 'delete-venues', 'display_name' => 'Delete Venues', 'group' => 'venues', 'description' => 'Delete venues'],

            ['name' => 'manage-offers', 'display_name' => 'Manage Offers', 'group' => 'offers', 'description' => 'Full access to offer management'],
            ['name' => 'view-offers', 'display_name' => 'View Offers', 'group' => 'offers', 'description' => 'View offer list and details'],
            ['name' => 'approve-offers', 'display_name' => 'Approve Offers', 'group' => 'offers', 'description' => 'Approve or reject offers'],
            ['name' => 'edit-offers', 'display_name' => 'Edit Offers', 'group' => 'offers', 'description' => 'Edit offer information'],
            ['name' => 'delete-offers', 'display_name' => 'Delete Offers', 'group' => 'offers', 'description' => 'Delete offers'],

            ['name' => 'manage-categories', 'display_name' => 'Manage Categories', 'group' => 'categories', 'description' => 'Full access to category management'],

            // Content
            ['name' => 'manage-reviews', 'display_name' => 'Manage Reviews', 'group' => 'content', 'description' => 'Moderate and manage reviews'],
            ['name' => 'manage-spotlight', 'display_name' => 'Manage Spotlight', 'group' => 'content', 'description' => 'Manage spotlight posts'],
            ['name' => 'manage-moderation', 'display_name' => 'Manage Moderation', 'group' => 'content', 'description' => 'Access content moderation tools'],

            // Financial
            ['name' => 'manage-subscription-plans', 'display_name' => 'Manage Subscription Plans', 'group' => 'financial', 'description' => 'Create and edit subscription plans'],
            ['name' => 'view-user-subscriptions', 'display_name' => 'View User Subscriptions', 'group' => 'financial', 'description' => 'View user subscription data'],
            ['name' => 'view-business-subscriptions', 'display_name' => 'View Business Subscriptions', 'group' => 'financial', 'description' => 'View business subscription data'],
            ['name' => 'view-payments', 'display_name' => 'View Payments', 'group' => 'financial', 'description' => 'View payment transactions'],
            ['name' => 'view-reports', 'display_name' => 'View Reports', 'group' => 'financial', 'description' => 'Access financial reports'],

            // Marketing
            ['name' => 'manage-marketing', 'display_name' => 'Manage Marketing', 'group' => 'marketing', 'description' => 'Create and manage marketing campaigns'],

            // Support
            ['name' => 'manage-support-tickets', 'display_name' => 'Manage Support Tickets', 'group' => 'support', 'description' => 'View and respond to support tickets'],
            ['name' => 'manage-notifications', 'display_name' => 'Manage Notifications', 'group' => 'support', 'description' => 'Send and manage notifications'],

            // System
            ['name' => 'manage-configuration', 'display_name' => 'Manage Configuration', 'group' => 'system', 'description' => 'Edit system configuration'],
            ['name' => 'manage-roles', 'display_name' => 'Manage Roles', 'group' => 'system', 'description' => 'Create and edit roles and permissions'],
            ['name' => 'manage-settings', 'display_name' => 'Manage Settings', 'group' => 'system', 'description' => 'Access system settings'],
            ['name' => 'view-audit-logs', 'display_name' => 'View Audit Logs', 'group' => 'system', 'description' => 'View system audit logs'],
        ];

        // Create or update permissions
        foreach ($permissions as $permissionData) {
            Permission::updateOrCreate(
                ['name' => $permissionData['name']],
                $permissionData
            );
        }

        $this->command->info('Permissions created successfully!');

        // Assign all permissions to super_admin role
        $superAdminRole = Role::where('name', 'super_admin')->first();
        if ($superAdminRole) {
            $allPermissions = Permission::all()->pluck('id');
            $superAdminRole->permissions()->sync($allPermissions);
            $this->command->info('All permissions assigned to super_admin role!');
        }
    }
}
