<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;

class AdminRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get or create super_admin role
        $superAdminRole = Role::firstOrCreate(['name' => 'super_admin']);
        $adminRole = Role::firstOrCreate(['name' => 'admin']);

        // Find the first admin user (usually ID 1 from initial setup)
        $adminUser = User::first();

        if ($adminUser) {
            // Assign super_admin role to first user
            if (!$adminUser->hasRole('super_admin')) {
                $adminUser->assignRole('super_admin');
                $this->command->info("✅ Assigned super_admin role to user: {$adminUser->email}");
            } else {
                $this->command->info("⚠️  User {$adminUser->email} already has super_admin role");
            }
        } else {
            $this->command->info("❌ No users found in database");
        }

        // Check all admin users
        $adminUsers = User::where('email', 'like', '%admin%')->orWhere('email', 'like', '%@admin%')->get();

        foreach ($adminUsers as $user) {
            if (!$user->hasAnyRole(['super_admin', 'admin'])) {
                $user->assignRole('admin');
                $this->command->info("✅ Assigned admin role to: {$user->email}");
            }
        }

        $this->command->info('✅ Admin roles assigned successfully!');
    }
}

