<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('🌱 Seeding categories...');

        $categories = [
            ['name' => 'Restaurants', 'name_ar' => 'المطاعم', 'slug' => 'restaurants', 'icon' => 'svg/categories/restaurants.svg', 'description' => 'Restaurants and dining establishments'],
            ['name' => 'Cafes', 'name_ar' => 'المقاهي', 'slug' => 'cafes', 'icon' => 'svg/categories/cafes.svg', 'description' => 'Coffee shops and cafes'],
            ['name' => 'Hotels', 'name_ar' => 'الفنادق', 'slug' => 'hotels', 'icon' => 'svg/categories/hotels.svg', 'description' => 'Hotels and accommodations'],
            ['name' => 'Spas', 'name_ar' => 'منتجعات صحية', 'slug' => 'spas', 'icon' => 'svg/categories/spas.svg', 'description' => 'Spas and wellness centers'],
            ['name' => 'Shopping', 'name_ar' => 'التسوق', 'slug' => 'shopping', 'icon' => 'svg/categories/shopping.svg', 'description' => 'Retail and shopping'],
            ['name' => 'Entertainment', 'name_ar' => 'الترفيه', 'slug' => 'entertainment', 'icon' => 'svg/categories/entertainment.svg', 'description' => 'Entertainment venues'],
            ['name' => 'Fitness', 'name_ar' => 'اللياقة البدنية', 'slug' => 'fitness', 'icon' => 'svg/categories/fitness.svg', 'description' => 'Gyms and fitness centers'],
            ['name' => 'Beauty', 'name_ar' => 'الجمال', 'slug' => 'beauty', 'icon' => 'svg/categories/beauty.svg', 'description' => 'Beauty and salons'],
            ['name' => 'Travel', 'name_ar' => 'السفر', 'slug' => 'travel', 'icon' => 'svg/categories/travel.svg', 'description' => 'Travel and tours'],
            ['name' => 'Education', 'name_ar' => 'التعليم', 'slug' => 'education', 'icon' => 'svg/categories/education.svg', 'description' => 'Educational institutions'],
            ['name' => 'Healthcare', 'name_ar' => 'الرعاية الصحية', 'slug' => 'healthcare', 'icon' => 'svg/categories/healthcare.svg', 'description' => 'Healthcare services'],
            ['name' => 'Real Estate', 'name_ar' => 'العقارات', 'slug' => 'real-estate', 'icon' => 'svg/categories/real-estate.svg', 'description' => 'Real estate services'],
        ];

        foreach ($categories as $category) {
            Category::updateOrCreate(
                ['slug' => $category['slug']],
                [
                    'name' => $category['name'],
                    'name_ar' => $category['name_ar'],
                    'icon' => $category['icon'],
                    'description' => $category['description'],
                    'is_active' => true,
                ]
            );

            $this->command->info("✅ Created category: {$category['name']}");
        }

        $this->command->info('✅ Categories seeded successfully!');
    }
}

