<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class CreateAdminPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()['cache']->forget('spatie.permission.cache');

        // Define all permissions
        $permissions = [
            // Admin Access
            'admin.access',
            'admin.dashboard',
            'admin.settings',

            // User Permissions
            'users.view',
            'users.create',
            'users.update',
            'users.delete',
            'users.export',
            'users.bulk_update',
            'users.restore',

            // Role Permissions
            'roles.view',
            'roles.create',
            'roles.update',
            'roles.delete',
            'roles.assign',

            // Permission Permissions
            'permissions.view',
            'permissions.create',
            'permissions.update',
            'permissions.delete',

            // Activity & Audit
            'activities.view',
            'activities.export',
            'activities.purge',

            // Sessions
            'sessions.view',
            'sessions.terminate',
            'sessions.cleanup',

            // Configuration
            'configurations.view',
            'configurations.update',
            'configurations.backup',
            'configurations.restore',

            // Settings
            'settings.view',
            'settings.update',

            // Businesses
            'businesses.view',
            'businesses.create',
            'businesses.update',
            'businesses.delete',
            'businesses.approve',

            // Categories
            'categories.view',
            'categories.create',
            'categories.update',
            'categories.delete',

            // Offers
            'offers.view',
            'offers.create',
            'offers.update',
            'offers.delete',
            'offers.approve',

            // Venues
            'venues.view',
            'venues.create',
            'venues.update',
            'venues.delete',
            'venues.approve',

            // Reports
            'reports.view',
            'reports.export',

            // Subscriptions
            'subscriptions.view',
            'subscriptions.create',
            'subscriptions.update',
            'subscriptions.delete',

            // Payments
            'payments.view',
            'payments.refund',

            // Support
            'support.view',
            'support.respond',
            'support.close',
        ];

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles
        $superAdminRole = Role::firstOrCreate(['name' => 'super_admin']);
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $managerRole = Role::firstOrCreate(['name' => 'manager']);
        $businessOwnerRole = Role::firstOrCreate(['name' => 'business_owner']);
        $userRole = Role::firstOrCreate(['name' => 'user']);

        // Assign all permissions to super_admin
        $superAdminRole->syncPermissions(Permission::all());

        // Assign most permissions to admin (exclude purge and cleanup)
        $adminPermissions = Permission::whereNotIn('name', [
            'activities.purge',
            'sessions.cleanup',
            'admin.access',
        ])->get();
        $adminRole->syncPermissions($adminPermissions);

        // Assign limited permissions to manager
        $managerPermissions = Permission::whereIn('name', [
            'admin.access',
            'admin.dashboard',
            'users.view',
            'activities.view',
            'sessions.view',
            'reports.view',
        ])->get();
        $managerRole->syncPermissions($managerPermissions);

        // Assign business permissions to business_owner
        $businessPermissions = Permission::whereIn('name', [
            'businesses.view',
            'offers.view',
            'venues.view',
            'subscriptions.view',
            'reports.view',
        ])->get();
        $businessOwnerRole->syncPermissions($businessPermissions);

        // User role has minimal permissions
        $userRole->syncPermissions([]);

        $this->command->info('Admin permissions and roles have been created successfully!');
    }
}

