<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->command->info('🌱 Starting comprehensive database seeding...');
        $this->command->newLine();

        // Step 1: System Configuration (must be first)
        $this->command->info('📋 Step 1/8: Seeding system configurations...');
        $this->call(SystemConfigurationSeeder::class);
        $this->command->newLine();

        // Step 2: Categories (needed for businesses)
        $this->command->info('🏷️  Step 2/8: Seeding categories...');
        $this->call(CategorySeeder::class);
        $this->command->newLine();

        // Step 3: Subscription Plans
        $this->command->info('💳 Step 3/8: Seeding subscription plans...');
        $this->call(SubscriptionPlanSeeder::class);
        $this->command->newLine();

        // Step 4: Roles and Permissions (must be before users)
        $this->command->info('🔐 Step 4/8: Seeding roles and permissions...');
        $this->call(RolePermissionSeeder::class);
        $this->command->newLine();

        // Step 5: Users (with roles assigned)
        $this->command->info('👤 Step 5/8: Seeding users...');
        $this->call(UserSeeder::class);
        $this->command->newLine();

        // Step 6: Teams
        $this->command->info('👥 Step 6/8: Seeding teams...');
        $this->call(TeamSeeder::class);
        $this->command->newLine();

        // Step 7: Chats and Messages
        $this->command->info('💬 Step 7/8: Seeding chats and messages...');
        $this->call(ChatSeeder::class);
        $this->command->newLine();

        // Step 8: Templates (Email and SMS)
        $this->command->info('📬 Step 8/8: Seeding notification templates...');
        $this->call(EmailTemplateSeeder::class);
        $this->call(SmsTemplateSeeder::class);
        $this->command->newLine();

        // Final summary
        $this->command->info('✅ All database seeding completed successfully!');
        $this->command->newLine();

        // Display summary
        $this->displaySummary();
    }

    /**
     * Display seeding summary
     */
    private function displaySummary(): void
    {
        $this->command->info('📊 Seeding Summary:');
        $this->command->table(
            ['Component', 'Status'],
            [
                ['System Configurations', '✅ Complete'],
                ['Categories', '✅ Complete'],
                ['Subscription Plans', '✅ Complete'],
                ['Roles & Permissions', '✅ Complete'],
                ['Users', '✅ Complete'],
                ['Teams', '✅ Complete'],
                ['Chats & Messages', '✅ Complete'],
                ['Email Templates', '✅ Complete'],
                ['SMS Templates', '✅ Complete'],
            ]
        );

        $this->command->newLine();
        $this->command->info('🎉 Your Privasee platform is ready to use!');
        $this->command->newLine();

        // Display helpful information
        $this->command->info('📝 Test Credentials:');
        $this->command->table(
            ['User Type', 'Email', 'Password'],
            [
                ['Super Admin', 'superadmin@privasee.com', 'password123'],
                ['Admin', 'admin@privasee.com', 'password123'],
                ['Business Owner', 'owner@business.com', 'password123'],
                ['Regular User', 'john@privasee.com', 'password123'],
            ]
        );

        $this->command->newLine();
        $this->command->info('🚀 Next Steps:');
        $this->command->info('   1. Clear cache: php artisan cache:clear');
        $this->command->info('   2. Login with test credentials');
        $this->command->info('   3. Explore the admin panel');
        $this->command->info('   4. Create businesses and teams');
    }
}

