<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Seeder;

class EmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('🌱 Seeding email templates...');

        $templates = [
            // Account Templates
            [
                'name' => 'User Registration',
                'slug' => 'user_registration',
                'category' => 'account',
                'subject' => 'Welcome to Privasee, {{first_name}}!',
                'html_body' => '<h1>Welcome {{first_name}}!</h1><p>Thank you for registering. Please verify your email by clicking the link below:</p><p><a href="{{verification_link}}">Verify Email</a></p>',
                'available_variables' => json_encode(['first_name', 'last_name', 'email', 'verification_link']),
                'is_active' => true,
            ],
            [
                'name' => 'Password Reset',
                'slug' => 'password_reset',
                'category' => 'account',
                'subject' => 'Reset Your Privasee Password',
                'html_body' => '<h1>Password Reset Request</h1><p>Hi {{first_name}},</p><p>Click the link below to reset your password (expires in {{expiry_hours}} hours):</p><p><a href="{{reset_link}}">Reset Password</a></p>',
                'available_variables' => json_encode(['first_name', 'reset_link', 'expiry_hours']),
                'is_active' => true,
            ],
            [
                'name' => 'Email Verification',
                'slug' => 'email_verification',
                'category' => 'account',
                'subject' => 'Verify Your Email Address',
                'html_body' => '<h1>Email Verification</h1><p>Hi {{first_name}},</p><p>Please verify your email address by clicking the link below:</p><p><a href="{{verification_link}}">Verify Email</a></p>',
                'available_variables' => json_encode(['first_name', 'verification_link']),
                'is_active' => true,
            ],

            // Team Templates
            [
                'name' => 'Team Invitation',
                'slug' => 'team_invitation',
                'category' => 'team',
                'subject' => 'You\'ve been invited to join {{team_name}}',
                'html_body' => '<h1>Team Invitation</h1><p>Hi {{first_name}},</p><p>{{invited_by}} has invited you to join the {{team_name}} team at {{business_name}}.</p><p><a href="{{invitation_link}}">Accept Invitation</a></p>',
                'available_variables' => json_encode(['first_name', 'team_name', 'business_name', 'invited_by', 'invitation_link']),
                'is_active' => true,
            ],
            [
                'name' => 'Team Member Added',
                'slug' => 'team_member_added',
                'category' => 'team',
                'subject' => '{{member_name}} has joined {{team_name}}',
                'html_body' => '<h1>New Team Member</h1><p>{{member_name}} ({{member_role}}) has joined the {{team_name}} team.</p>',
                'available_variables' => json_encode(['team_name', 'member_name', 'member_role']),
                'is_active' => true,
            ],

            // Business Templates
            [
                'name' => 'Business Verified',
                'slug' => 'business_verified',
                'category' => 'business',
                'subject' => 'Your Business {{business_name}} Has Been Verified!',
                'html_body' => '<h1>Business Verified</h1><p>Congratulations! Your business {{business_name}} has been verified.</p><p><a href="{{dashboard_link}}">Go to Dashboard</a></p>',
                'available_variables' => json_encode(['business_name', 'dashboard_link']),
                'is_active' => true,
            ],
            [
                'name' => 'Business Rejected',
                'slug' => 'business_rejected',
                'category' => 'business',
                'subject' => 'Business Verification - Additional Information Needed',
                'html_body' => '<h1>Business Verification Required</h1><p>We need additional information to verify your business {{business_name}}.</p><p>Reason: {{rejection_reason}}</p><p><a href="{{support_link}}">Contact Support</a></p>',
                'available_variables' => json_encode(['business_name', 'rejection_reason', 'support_link']),
                'is_active' => true,
            ],

            // Chat Templates
            [
                'name' => 'New Chat Message',
                'slug' => 'new_chat_message',
                'category' => 'chat',
                'subject' => 'New message from {{sender_name}} in {{chat_name}}',
                'html_body' => '<h1>New Message</h1><p>{{sender_name}} sent you a message in {{chat_name}}:</p><p>{{message_preview}}</p><p><a href="{{chat_link}}">View Chat</a></p>',
                'available_variables' => json_encode(['sender_name', 'chat_name', 'message_preview', 'chat_link']),
                'is_active' => true,
            ],

            // Notification Templates
            [
                'name' => 'Notification Center',
                'slug' => 'notification_center',
                'category' => 'notifications',
                'subject' => 'Your Privasee Notifications',
                'html_body' => '<h1>Your Notifications</h1><p>Hi {{first_name}},</p><p>You have new notifications:</p><p>{{notifications_list}}</p>',
                'available_variables' => json_encode(['first_name', 'notifications_list']),
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::updateOrCreate(
                ['slug' => $template['slug']],
                $template
            );

            $this->command->info("✅ Created email template: {$template['name']}");
        }

        $this->command->info('✅ Email templates seeded successfully!');
    }
}

