<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MarketingPackage;

class MarketingPackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $packages = [
            [
                'name' => 'Social Media Starter',
                'name_ar' => 'حزمة وسائل التواصل الاجتماعي المبتدئة',
                'description' => 'Perfect for small businesses starting their social media journey. Includes Facebook and Instagram posts.',
                'description_ar' => 'مثالية للشركات الصغيرة التي تبدأ رحلتها على وسائل التواصل الاجتماعي. تشمل منشورات فيسبوك وإنستغرام.',
                'type' => 'social',
                'price' => 299.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 10000,
                'clicks_limit' => 500,
                'conversions_limit' => 50,
                'features' => [
                    '10 social media posts per month',
                    'Facebook & Instagram coverage',
                    'Basic analytics dashboard',
                    'Audience targeting',
                    'Content scheduling'
                ],
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Social Media Pro',
                'name_ar' => 'حزمة وسائل التواصل الاجتماعي المحترفة',
                'description' => 'Advanced social media marketing with broader reach and engagement. Multi-platform coverage.',
                'description_ar' => 'تسويق متقدم عبر وسائل التواصل الاجتماعي مع وصول وتفاعل أوسع. تغطية متعددة المنصات.',
                'type' => 'social',
                'price' => 799.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 50000,
                'clicks_limit' => 2500,
                'conversions_limit' => 250,
                'features' => [
                    '30 social media posts per month',
                    'All major platforms (Facebook, Instagram, Twitter, LinkedIn)',
                    'Advanced analytics & reporting',
                    'A/B testing',
                    'Audience insights',
                    'Priority support'
                ],
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Email Marketing Basic',
                'name_ar' => 'التسويق عبر البريد الإلكتروني الأساسي',
                'description' => 'Reach your customers directly with targeted email campaigns.',
                'description_ar' => 'الوصول إلى عملائك مباشرة من خلال حملات البريد الإلكتروني المستهدفة.',
                'type' => 'email',
                'price' => 199.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 5000,
                'clicks_limit' => 250,
                'conversions_limit' => 25,
                'features' => [
                    'Send to 5,000 subscribers',
                    'Email template library',
                    'Basic segmentation',
                    'Open & click tracking',
                    'Mobile-optimized templates'
                ],
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'SMS Campaign',
                'name_ar' => 'حملة الرسائل النصية القصيرة',
                'description' => 'Direct SMS marketing to your customer base with high open rates.',
                'description_ar' => 'التسويق المباشر عبر الرسائل النصية القصيرة لقاعدة عملائك بمعدلات فتح عالية.',
                'type' => 'sms',
                'price' => 399.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 3000,
                'clicks_limit' => 600,
                'conversions_limit' => 90,
                'features' => [
                    '3,000 SMS messages',
                    'Delivery confirmation',
                    'Link tracking',
                    'Scheduled sending',
                    'Customer opt-out management'
                ],
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Push Notification Campaign',
                'name_ar' => 'حملة الإشعارات الفورية',
                'description' => 'Engage app users with timely push notifications.',
                'description_ar' => 'تفاعل مع مستخدمي التطبيق من خلال الإشعارات الفورية في الوقت المناسب.',
                'type' => 'push',
                'price' => 249.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 10000,
                'clicks_limit' => 1000,
                'conversions_limit' => 100,
                'features' => [
                    'Unlimited push notifications',
                    'Geo-targeting',
                    'Behavior-based triggers',
                    'A/B testing',
                    'Rich media support'
                ],
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Display Ads Campaign',
                'name_ar' => 'حملة الإعلانات المصورة',
                'description' => 'Eye-catching display ads across premium websites and apps.',
                'description_ar' => 'إعلانات مصورة لافتة للنظر عبر المواقع والتطبيقات المتميزة.',
                'type' => 'display',
                'price' => 999.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 100000,
                'clicks_limit' => 3000,
                'conversions_limit' => 300,
                'features' => [
                    '100,000 ad impressions',
                    'Multiple ad formats',
                    'Retargeting capabilities',
                    'Premium ad placements',
                    'Detailed performance metrics',
                    'Creative design support'
                ],
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Complete Marketing Package',
                'name_ar' => 'الحزمة التسويقية الشاملة',
                'description' => 'All-in-one marketing solution combining social, email, SMS, and push notifications.',
                'description_ar' => 'حل تسويقي شامل يجمع بين وسائل التواصل الاجتماعي والبريد الإلكتروني والرسائل النصية والإشعارات الفورية.',
                'type' => 'mixed',
                'price' => 1499.00,
                'currency' => 'AED',
                'duration_days' => 30,
                'impressions_limit' => 200000,
                'clicks_limit' => 10000,
                'conversions_limit' => 1000,
                'features' => [
                    'Multi-channel campaigns',
                    'Unlimited social posts',
                    '10,000 email sends',
                    '5,000 SMS messages',
                    'Unlimited push notifications',
                    'Advanced analytics dashboard',
                    'Dedicated account manager',
                    'Priority support',
                    'Custom reporting'
                ],
                'is_active' => true,
                'sort_order' => 7,
            ],
        ];

        foreach ($packages as $package) {
            MarketingPackage::create($package);
        }
    }
}
