<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()['cache']->forget('spatie.permission.cache');

        // Define all permissions
        $permissions = [
            // Dashboard
            'admin.dashboard' => 'Access admin dashboard',
            'admin.access' => 'Access admin panel',

            // Users
            'users.view' => 'View users',
            'users.create' => 'Create users',
            'users.edit' => 'Edit users',
            'users.delete' => 'Delete users',

            // Roles
            'roles.view' => 'View roles',
            'roles.create' => 'Create roles',
            'roles.edit' => 'Edit roles',
            'roles.delete' => 'Delete roles',

            // Permissions
            'permissions.view' => 'View permissions',
            'permissions.create' => 'Create permissions',
            'permissions.edit' => 'Edit permissions',
            'permissions.delete' => 'Delete permissions',

            // Activities & Audit
            'activities.view' => 'View activities',
            'activities.export' => 'Export activities',

            // Sessions
            'sessions.view' => 'View admin sessions',
            'sessions.manage' => 'Manage admin sessions',

            // Configurations
            'configurations.view' => 'View configurations',
            'configurations.manage' => 'Manage configurations',

            // Settings
            'settings.view' => 'View settings',
            'settings.manage' => 'Manage settings',

            // Businesses
            'businesses.view' => 'View businesses',
            'businesses.create' => 'Create businesses',
            'businesses.edit' => 'Edit businesses',
            'businesses.delete' => 'Delete businesses',

            // Venues
            'venues.view' => 'View venues',
            'venues.create' => 'Create venues',
            'venues.edit' => 'Edit venues',
            'venues.delete' => 'Delete venues',

            // Teams
            'teams.view' => 'View teams',
            'teams.create' => 'Create teams',
            'teams.edit' => 'Edit teams',
            'teams.delete' => 'Delete teams',

            // Staff
            'staff.view' => 'View staff',
            'staff.create' => 'Create staff',
            'staff.edit' => 'Edit staff',
            'staff.delete' => 'Delete staff',

            // Chats
            'chats.view' => 'View chats',
            'chats.create' => 'Create chats',
            'chats.edit' => 'Edit chats',
            'chats.delete' => 'Delete chats',

            // Notifications
            'notifications.manage_templates' => 'Manage notification templates',
            'notifications.view' => 'View notifications',

            // Categories
            'categories.view' => 'View categories',
            'categories.create' => 'Create categories',
            'categories.edit' => 'Edit categories',
            'categories.delete' => 'Delete categories',

            // Offers
            'offers.view' => 'View offers',
            'offers.create' => 'Create offers',
            'offers.edit' => 'Edit offers',
            'offers.delete' => 'Delete offers',

            // Reviews
            'reviews.view' => 'View reviews',
            'reviews.create' => 'Create reviews',
            'reviews.edit' => 'Edit reviews',
            'reviews.delete' => 'Delete reviews',

            // Subscriptions
            'subscriptions.view' => 'View subscriptions',
            'subscriptions.manage' => 'Manage subscriptions',

            // Support
            'support.view' => 'View support tickets',
            'support.create' => 'Create support tickets',
            'support.respond' => 'Respond to support tickets',

            // Analytics
            'analytics.view' => 'View analytics',
            'analytics.export' => 'Export analytics',
        ];

        // Create permissions
        foreach ($permissions as $permission => $description) {
            Permission::firstOrCreate(
                ['name' => $permission],
                ['description' => $description]
            );
        }

        // Get all permissions
        $allPermissions = Permission::all();

        // Create Super Admin Role with all permissions
        $superAdminRole = Role::firstOrCreate(['name' => 'super_admin']);
        $superAdminRole->syncPermissions($allPermissions);

        // Create Admin Role with most permissions (exclude dangerous ones)
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $adminPermissions = $allPermissions->filter(function ($permission) {
            return !in_array($permission->name, [
                // Exclude dangerous permissions for regular admins
            ]);
        });
        $adminRole->syncPermissions($adminPermissions);

        // Create Manager Role with limited permissions
        $managerRole = Role::firstOrCreate(['name' => 'manager']);
        $managerPermissions = [
            'admin.access',
            'admin.dashboard',
            'users.view',
            'roles.view',
            'activities.view',
            'sessions.view',
            'configurations.view',
            'settings.view',
            'businesses.view',
            'venues.view',
            'teams.view',
            'staff.view',
            'chats.view',
            'notifications.view',
            'categories.view',
            'offers.view',
            'reviews.view',
            'subscriptions.view',
            'support.view',
            'analytics.view',
        ];
        $managerRole->syncPermissions(
            Permission::whereIn('name', $managerPermissions)->get()
        );

        $this->command->info('✅ Permissions and roles created successfully!');
        $this->command->info('Total permissions: ' . count($permissions));
        $this->command->info('Roles created: super_admin, admin, manager');
    }
}

