<?php

namespace Database\Seeders;

use App\Models\SmsTemplate;
use Illuminate\Database\Seeder;

class SmsTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('🌱 Seeding SMS templates...');

        $templates = [
            [
                'name' => 'OTP Verification',
                'slug' => 'otp_verification',
                'category' => 'account',
                'content' => 'Your Privasee OTP is: {{otp}}. Valid for {{expiry_minutes}} minutes. Do not share this code.',
                'available_variables' => ['otp', 'expiry_minutes'],
                'is_active' => true,
            ],
            [
                'name' => 'Password Reset OTP',
                'slug' => 'password_reset_otp',
                'category' => 'account',
                'content' => 'Your Privasee password reset code is: {{otp}}. Do not share with anyone. Expires in {{expiry_hours}} hours.',
                'available_variables' => ['otp', 'expiry_hours'],
                'is_active' => true,
            ],
            [
                'name' => 'Login Alert',
                'slug' => 'login_alert',
                'category' => 'account',
                'content' => 'New login to your Privasee account from {{device}} at {{time}}. If this wasn\'t you, change your password immediately.',
                'available_variables' => ['device', 'time'],
                'is_active' => true,
            ],
            [
                'name' => 'Team Invitation SMS',
                'slug' => 'team_invitation_sms',
                'category' => 'team',
                'content' => 'You\'re invited to join {{team_name}} at {{business_name}}. Link: {{invitation_link}}',
                'available_variables' => ['team_name', 'business_name', 'invitation_link'],
                'is_active' => true,
            ],
            [
                'name' => 'New Chat Message SMS',
                'slug' => 'new_chat_message_sms',
                'category' => 'chat',
                'content' => 'New message from {{sender_name}} in {{chat_name}}: {{message_preview}}',
                'available_variables' => ['sender_name', 'chat_name', 'message_preview'],
                'is_active' => true,
            ],
            [
                'name' => 'Offer Alert SMS',
                'slug' => 'offer_alert_sms',
                'category' => 'offers',
                'content' => 'New offer at {{venue_name}}: {{offer_title}}. Valid until {{valid_until}}. Check now!',
                'available_variables' => ['venue_name', 'offer_title', 'valid_until'],
                'is_active' => true,
            ],
            [
                'name' => 'Redemption Confirmation',
                'slug' => 'redemption_confirmation',
                'category' => 'redemptions',
                'content' => 'Your {{offer_title}} has been redeemed at {{venue_name}}. Enjoy!',
                'available_variables' => ['offer_title', 'venue_name'],
                'is_active' => true,
            ],
            [
                'name' => 'Subscription Renewal',
                'slug' => 'subscription_renewal',
                'category' => 'subscription',
                'content' => 'Your {{plan_name}} subscription will renew on {{renewal_date}}. Amount: {{amount}} {{currency}}.',
                'available_variables' => ['plan_name', 'renewal_date', 'amount', 'currency'],
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            SmsTemplate::updateOrCreate(
                ['slug' => $template['slug']],
                [
                    'name' => $template['name'],
                    'category' => $template['category'],
                    'content' => $template['content'],
                    'available_variables' => $template['available_variables'],
                    'character_count' => strlen($template['content']),
                    'is_active' => $template['is_active'],
                ]
            );

            $this->command->info("✅ Created SMS template: {$template['name']}");
        }

        $this->command->info('✅ SMS templates seeded successfully!');
    }
}

