<?php

namespace Database\Seeders;

use App\Models\SubscriptionPlan;
use Illuminate\Database\Seeder;

class SubscriptionPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('🌱 Seeding subscription plans...');

        $plans = [
            [
                'name' => 'Basic',
                'name_ar' => 'باسك',
                'description' => 'Perfect for starting out',
                'description_ar' => 'مثالي للبدء',
                'type' => 'business',
                'duration_type' => 'monthly',
                'duration_days' => 30,
                'price' => 99,
                'currency' => 'AED',
                'max_venues' => 1,
                'max_staff' => 3,
                'max_offers' => 10,
                'max_photos_per_venue' => 20,
                'analytics_access' => false,
                'priority_support' => false,
                'featured_listing' => false,
                'custom_branding' => false,
                'api_access' => false,
                'features' => json_encode([
                    'venues' => 1,
                    'staff' => 3,
                    'offers' => 10,
                    'support' => 'email',
                ]),
                'is_active' => true,
                'is_popular' => false,
                'sort_order' => 1,
            ],
            [
                'name' => 'Professional',
                'name_ar' => 'احترافي',
                'description' => 'For growing businesses',
                'description_ar' => 'للأعمال المتنامية',
                'type' => 'business',
                'duration_type' => 'monthly',
                'duration_days' => 30,
                'price' => 299,
                'currency' => 'AED',
                'max_venues' => 5,
                'max_staff' => 20,
                'max_offers' => 50,
                'max_photos_per_venue' => 50,
                'analytics_access' => true,
                'priority_support' => true,
                'featured_listing' => true,
                'custom_branding' => false,
                'api_access' => false,
                'features' => json_encode([
                    'venues' => 5,
                    'staff' => 20,
                    'offers' => 50,
                    'support' => 'priority',
                    'analytics' => true,
                ]),
                'is_active' => true,
                'is_popular' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Enterprise',
                'name_ar' => 'مؤسسة',
                'description' => 'For large organizations',
                'description_ar' => 'للمنظمات الكبيرة',
                'type' => 'business',
                'duration_type' => 'yearly',
                'duration_days' => 365,
                'price' => 999,
                'currency' => 'AED',
                'max_venues' => null, // unlimited
                'max_staff' => null, // unlimited
                'max_offers' => null, // unlimited
                'max_photos_per_venue' => null, // unlimited
                'analytics_access' => true,
                'priority_support' => true,
                'featured_listing' => true,
                'custom_branding' => true,
                'api_access' => true,
                'features' => json_encode([
                    'venues' => 'unlimited',
                    'staff' => 'unlimited',
                    'offers' => 'unlimited',
                    'support' => '24/7',
                    'analytics' => true,
                    'api_access' => true,
                    'custom_branding' => true,
                ]),
                'is_active' => true,
                'is_popular' => false,
                'sort_order' => 3,
            ],
            [
                'name' => 'Free Trial',
                'name_ar' => 'تجربة مجانية',
                'description' => '14 days free trial',
                'description_ar' => '14 يوم تجربة مجانية',
                'type' => 'business',
                'duration_type' => 'monthly',
                'duration_days' => 14,
                'price' => 0,
                'currency' => 'AED',
                'max_venues' => 2,
                'max_staff' => 5,
                'max_offers' => 20,
                'max_photos_per_venue' => 30,
                'analytics_access' => false,
                'priority_support' => false,
                'featured_listing' => false,
                'custom_branding' => false,
                'api_access' => false,
                'features' => json_encode([
                    'venues' => 2,
                    'staff' => 5,
                    'offers' => 20,
                    'support' => 'email',
                ]),
                'is_active' => true,
                'is_popular' => false,
                'sort_order' => 0,
            ],
        ];

        foreach ($plans as $plan) {
            SubscriptionPlan::updateOrCreate(
                ['name' => $plan['name']],
                $plan
            );

            $this->command->info("✅ Created subscription plan: {$plan['name']}");
        }

        $this->command->info('✅ Subscription plans seeded successfully!');
    }
}



