<?php

namespace Database\Seeders;

use App\Models\SystemConfiguration;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SystemConfigurationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Define all system configurations
        $configurations = [
            // ===== EMAIL NOTIFICATIONS =====
            [
                'key' => 'notifications.email.enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'notifications',
                'description' => 'Enable email notifications system-wide',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.email.from_address',
                'value' => 'noreply@privasee.com',
                'type' => 'string',
                'category' => 'notifications',
                'description' => 'Email address to send notifications from',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.email.from_name',
                'value' => 'Privasee',
                'type' => 'string',
                'category' => 'notifications',
                'description' => 'Name to display in notification emails',
                'is_public' => false,
            ],

            // ===== SMS NOTIFICATIONS =====
            [
                'key' => 'notifications.sms.enabled',
                'value' => '0',
                'type' => 'boolean',
                'category' => 'notifications',
                'description' => 'Enable SMS notifications',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.sms.provider',
                'value' => 'twilio',
                'type' => 'string',
                'category' => 'notifications',
                'description' => 'SMS provider (twilio, nexmo, etc)',
                'is_public' => false,
            ],

            // ===== PUSH NOTIFICATIONS =====
            [
                'key' => 'notifications.push.enabled',
                'value' => '0',
                'type' => 'boolean',
                'category' => 'notifications',
                'description' => 'Enable push notifications',
                'is_public' => false,
            ],

            // ===== NOTIFICATION CHANNELS - BUSINESS EVENTS =====
            [
                'key' => 'notifications.channels.offer_redeemed',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for offer redeemed notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.offer_rejected',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for offer rejected notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.offer_redeemed_business',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for business owner when offer is redeemed',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.staff_invited',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for staff invitation notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.offer_created',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for new offer created notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.venue_created',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for new venue created notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.subscription_upgraded',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for subscription upgrade notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.subscription_pending',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for pending subscription payment notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.team_added',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for team member added notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.chat_created',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for new chat created notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.new_message',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for new message notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.support_ticket_created',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for support ticket created notification',
                'is_public' => false,
            ],

            // ===== NOTIFICATION CHANNELS - ADMIN EVENTS =====
            [
                'key' => 'notifications.channels.user_status_changed',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for user status changed notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.business_verified',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for business verified notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.business_rejected',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for business rejected notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.support_ticket_closed',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for support ticket closed notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.support_ticket_reopened',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for support ticket reopened notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.support_ticket_replied',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for support ticket replied notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.support_ticket_status_changed',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for support ticket status changed notification',
                'is_public' => false,
            ],
            [
                'key' => 'notifications.channels.support_ticket_assigned',
                'value' => json_encode(['database']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for support ticket assigned notification',
                'is_public' => false,
            ],

            // ===== NOTIFICATION CHANNELS - PAYMENT EVENTS =====
            [
                'key' => 'notifications.channels.payment_confirmed',
                'value' => json_encode(['database', 'email']),
                'type' => 'array',
                'category' => 'notifications',
                'description' => 'Channels for payment confirmed notification',
                'is_public' => false,
            ],

            // ===== EMAIL SETTINGS =====
            [
                'key' => 'email.driver',
                'value' => 'smtp',
                'type' => 'string',
                'category' => 'email',
                'description' => 'Email driver (smtp, mailgun, etc)',
                'is_public' => false,
            ],
            [
                'key' => 'email.host',
                'value' => 'smtp.mailtrap.io',
                'type' => 'string',
                'category' => 'email',
                'description' => 'SMTP host for email',
                'is_public' => false,
            ],
            [
                'key' => 'email.port',
                'value' => '2525',
                'type' => 'integer',
                'category' => 'email',
                'description' => 'SMTP port',
                'is_public' => false,
            ],

            // ===== SMS SETTINGS =====
            [
                'key' => 'sms.twilio.account_sid',
                'value' => '',
                'type' => 'string',
                'category' => 'sms',
                'description' => 'Twilio Account SID',
                'is_public' => false,
            ],
            [
                'key' => 'sms.twilio.auth_token',
                'value' => '',
                'type' => 'string',
                'category' => 'sms',
                'description' => 'Twilio Auth Token',
                'is_public' => false,
            ],
            [
                'key' => 'sms.twilio.from_number',
                'value' => '',
                'type' => 'string',
                'category' => 'sms',
                'description' => 'Twilio Phone Number to send from',
                'is_public' => false,
            ],

            // ===== PAYMENT SETTINGS =====
            [
                'key' => 'payment.stripe.enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'payment',
                'description' => 'Enable Stripe payment gateway',
                'is_public' => false,
            ],
            [
                'key' => 'payment.paypal.enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'payment',
                'description' => 'Enable PayPal payment gateway',
                'is_public' => false,
            ],

            // ===== BUSINESS VERIFICATION SETTINGS =====
            [
                'key' => 'business.verification.auto_approve',
                'value' => '0',
                'type' => 'boolean',
                'category' => 'business',
                'description' => 'Auto approve businesses (requires manual verification if false)',
                'is_public' => false,
            ],
            [
                'key' => 'business.verification.require_documents',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'business',
                'description' => 'Require trade license and documents for verification',
                'is_public' => false,
            ],
            [
                'key' => 'business.verification.require_payment',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'business',
                'description' => 'Require payment method before allowing offers',
                'is_public' => false,
            ],

            // ===== BUSINESS SETTINGS =====
            [
                'key' => 'business.min_staff',
                'value' => '1',
                'type' => 'integer',
                'category' => 'business',
                'description' => 'Minimum staff members required',
                'is_public' => false,
            ],
            [
                'key' => 'business.max_staff_free_plan',
                'value' => '3',
                'type' => 'integer',
                'category' => 'business',
                'description' => 'Maximum staff for free plan',
                'is_public' => false,
            ],

            // ===== OFFER SETTINGS =====
            [
                'key' => 'offer.max_redemptions_default',
                'value' => '100',
                'type' => 'integer',
                'category' => 'offer',
                'description' => 'Default max redemptions per offer',
                'is_public' => false,
            ],
            [
                'key' => 'offer.max_per_user_default',
                'value' => '1',
                'type' => 'integer',
                'category' => 'offer',
                'description' => 'Default max times per user can redeem same offer',
                'is_public' => false,
            ],

            // ===== SYSTEM SETTINGS =====
            [
                'key' => 'system.maintenance_mode',
                'value' => '0',
                'type' => 'boolean',
                'category' => 'system',
                'description' => 'Enable maintenance mode',
                'is_public' => false,
            ],
            [
                'key' => 'system.maintenance_message',
                'value' => 'The system is under maintenance. Please try again later.',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Maintenance mode message',
                'is_public' => false,
            ],
            [
                'key' => 'system.app_name',
                'value' => 'Privasee',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Application name',
                'is_public' => true,
            ],
            [
                'key' => 'system.app_version',
                'value' => '1.0.0',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Application version',
                'is_public' => true,
            ],

            // ===== SECURITY SETTINGS =====
            [
                'key' => 'security.password_min_length',
                'value' => '8',
                'type' => 'integer',
                'category' => 'security',
                'description' => 'Minimum password length',
                'is_public' => false,
            ],
            [
                'key' => 'security.session_timeout',
                'value' => '120',
                'type' => 'integer',
                'category' => 'security',
                'description' => 'Session timeout in minutes',
                'is_public' => false,
            ],
            [
                'key' => 'security.mfa_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'security',
                'description' => 'Enable multi-factor authentication',
                'is_public' => false,
            ],
        ];

        // Insert configurations, updating if they already exist
        foreach ($configurations as $config) {
            SystemConfiguration::updateOrCreate(
                ['key' => $config['key']],
                $config
            );
        }

        $this->command->info('System configurations seeded successfully!');
    }
}

