@extends('layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
<div class="container-fluid py-4">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-light border-0">
                <div class="card-body py-4">
                    <h4 class="mb-1">Welcome back, {{ auth()->user()->first_name }}!</h4>
                    <p class="text-muted mb-0">System Status: <span class="badge bg-success">All Systems Normal</span></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-3">Total Users</h6>
                    <h3 class="mb-2">{{ $stats['total_users'] ?? 0 }}</h3>
                    <small class="text-success">
                        <i class="fas fa-arrow-up"></i>
                        {{ $stats['new_this_month'] ?? 0 }} this month
                    </small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-3">Active Sessions</h6>
                    <h3 class="mb-2">{{ $stats['active_sessions'] ?? 0 }}</h3>
                    <small class="text-info">Admin users online</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-3">Recent Activities</h6>
                    <h3 class="mb-2">{{ $stats['today_activities'] ?? 0 }}</h3>
                    <small class="text-muted">Actions today</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-3">Security Alerts</h6>
                    <h3 class="mb-2">{{ $stats['security_alerts'] ?? 0 }}</h3>
                    <small class="text-warning">Last 24 hours</small>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <!-- Recent Activity -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Recent Admin Activities</h5>
                    <a href="/admin/activities" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Time</th>
                                <th>Admin</th>
                                <th>Action</th>
                                <th>Entity</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentActivities ?? [] as $activity)
                            <tr>
                                <td><small>{{ $activity->created_at->format('H:i') }}</small></td>
                                <td><small>{{ $activity->adminUser->first_name ?? 'N/A' }}</small></td>
                                <td>
                                    <span class="badge bg-primary">{{ ucfirst($activity->action) }}</span>
                                </td>
                                <td><small>{{ $activity->entity_type }}</small></td>
                                <td>
                                    @if($activity->status === 'success')
                                        <span class="badge bg-success">Success</span>
                                    @else
                                        <span class="badge bg-danger">Failed</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">
                                    No activities yet
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Active Admin Sessions -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Active Admin Sessions</h5>
                    <a href="/admin/sessions" class="btn btn-sm btn-outline-primary">Manage</a>
                </div>
                <div class="list-group list-group-flush">
                    @forelse($activeSessions ?? [] as $session)
                    <div class="list-group-item">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h6 class="mb-1">{{ $session->user->first_name ?? 'N/A' }}</h6>
                                <small class="text-muted">
                                    <i class="fas fa-globe"></i> {{ $session->ip_address }}
                                    <br>
                                    <i class="fas fa-clock"></i> {{ $session->last_activity_at->diffForHumans() }}
                                </small>
                            </div>
                            <span class="badge bg-success">Active</span>
                        </div>
                    </div>
                    @empty
                    <div class="list-group-item text-center text-muted py-3">
                        No active sessions
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <!-- Top Users by Activity -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Most Active Admins (7 days)</h5>
                </div>
                <div class="list-group list-group-flush">
                    @forelse($topAdmins ?? [] as $admin)
                    <div class="list-group-item d-flex justify-content-between">
                        <div>
                            <h6 class="mb-0">{{ $admin->user->first_name ?? 'N/A' }} {{ $admin->user->last_name ?? '' }}</h6>
                            <small class="text-muted">{{ $admin->user->email ?? '' }}</small>
                        </div>
                        <span class="badge bg-primary">{{ $admin->count }} actions</span>
                    </div>
                    @empty
                    <div class="list-group-item text-center text-muted py-3">
                        No activity data
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- System Health -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">System Health</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-2">
                            <small>Database</small>
                            <small>Excellent</small>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-success" style="width: 100%"></div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-2">
                            <small>Cache</small>
                            <small>Good</small>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-info" style="width: 85%"></div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-2">
                            <small>Disk Space</small>
                            <small>Adequate</small>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-warning" style="width: 60%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Security & Audit Quick Actions -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Links</h5>
                </div>
                <div class="card-body">
                    <div class="row g-2">
                        <div class="col-md-2">
                            <a href="/admin/activities" class="btn btn-outline-primary w-100">
                                <i class="fas fa-list"></i><br>
                                <small>Activity Logs</small>
                            </a>
                        </div>
                        <div class="col-md-2">
                            <a href="/admin/sessions" class="btn btn-outline-primary w-100">
                                <i class="fas fa-users"></i><br>
                                <small>Admin Sessions</small>
                            </a>
                        </div>
                        <div class="col-md-2">
                            <a href="/admin/configurations" class="btn btn-outline-primary w-100">
                                <i class="fas fa-cog"></i><br>
                                <small>Configuration</small>
                            </a>
                        </div>
                        <div class="col-md-2">
                            <a href="/admin/roles" class="btn btn-outline-primary w-100">
                                <i class="fas fa-shield-alt"></i><br>
                                <small>Roles & Permissions</small>
                            </a>
                        </div>
                        <div class="col-md-2">
                            <a href="/admin/users" class="btn btn-outline-primary w-100">
                                <i class="fas fa-user-cog"></i><br>
                                <small>User Management</small>
                            </a>
                        </div>
                        <div class="col-md-2">
                            <a href="/admin/settings" class="btn btn-outline-primary w-100">
                                <i class="fas fa-sliders-h"></i><br>
                                <small>Settings</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

