@extends('layouts.admin')

@section('title', 'Analytics & Reports')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col">
            <h2 class="mb-1">Analytics & Reports</h2>
            <p class="text-muted">Platform performance and insights</p>
        </div>
        <div class="col-auto">
            <select class="form-select" id="dateRange">
                <option value="7">Last 7 Days</option>
                <option value="30" selected>Last 30 Days</option>
                <option value="90">Last 90 Days</option>
                <option value="365">Last Year</option>
            </select>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Total Users</p>
                            <h3 class="mb-0">12,543</h3>
                            <small class="text-success">
                                <i class="bi bi-arrow-up"></i> 12.5% vs last period
                            </small>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded p-3">
                            <i class="bi bi-people-fill text-primary fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Active Businesses</p>
                            <h3 class="mb-0">324</h3>
                            <small class="text-success">
                                <i class="bi bi-arrow-up"></i> 8.3% vs last period
                            </small>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded p-3">
                            <i class="bi bi-building text-success fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Total Offers</p>
                            <h3 class="mb-0">1,847</h3>
                            <small class="text-success">
                                <i class="bi bi-arrow-up"></i> 15.7% vs last period
                            </small>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded p-3">
                            <i class="bi bi-tag-fill text-warning fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Redemptions</p>
                            <h3 class="mb-0">8,921</h3>
                            <small class="text-success">
                                <i class="bi bi-arrow-up"></i> 23.4% vs last period
                            </small>
                        </div>
                        <div class="bg-info bg-opacity-10 rounded p-3">
                            <i class="bi bi-receipt text-info fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts -->
    <div class="row mb-4">
        <div class="col-lg-8 mb-4">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0">User Growth</h5>
                </div>
                <div class="card-body">
                    <canvas id="userGrowthChart" height="80"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0">User Distribution</h5>
                </div>
                <div class="card-body">
                    <canvas id="userTypeChart"></canvas>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between mb-2">
                            <span><i class="bi bi-circle-fill text-primary me-2"></i>Regular Users</span>
                            <span class="fw-bold">68%</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span><i class="bi bi-circle-fill text-success me-2"></i>Business Owners</span>
                            <span class="fw-bold">28%</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span><i class="bi bi-circle-fill text-warning me-2"></i>Admins</span>
                            <span class="fw-bold">4%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Redemptions Trend</h5>
                </div>
                <div class="card-body">
                    <canvas id="redemptionsChart" height="100"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Revenue Trend</h5>
                </div>
                <div class="card-body">
                    <canvas id="revenueChart" height="100"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Performers -->
    <div class="row">
        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Top Businesses</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th>Business</th>
                                    <th>Offers</th>
                                    <th>Redemptions</th>
                                    <th>Rating</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="fw-medium">Golden Fork Restaurant</div>
                                        <small class="text-muted">Food & Dining</small>
                                    </td>
                                    <td>42</td>
                                    <td>1,234</td>
                                    <td>
                                        <i class="bi bi-star-fill text-warning"></i> 4.8
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="fw-medium">City Fitness Center</div>
                                        <small class="text-muted">Health & Fitness</small>
                                    </td>
                                    <td>28</td>
                                    <td>987</td>
                                    <td>
                                        <i class="bi bi-star-fill text-warning"></i> 4.6
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="fw-medium">Luxury Spa & Wellness</div>
                                        <small class="text-muted">Beauty & Spa</small>
                                    </td>
                                    <td>35</td>
                                    <td>856</td>
                                    <td>
                                        <i class="bi bi-star-fill text-warning"></i> 4.9
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Top Categories</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th>Category</th>
                                    <th>Businesses</th>
                                    <th>Offers</th>
                                    <th>Performance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <i class="bi bi-cart text-primary me-2"></i>
                                        Food & Dining
                                    </td>
                                    <td>124</td>
                                    <td>547</td>
                                    <td>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-success" style="width: 85%"></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <i class="bi bi-heart-pulse text-danger me-2"></i>
                                        Health & Fitness
                                    </td>
                                    <td>89</td>
                                    <td>342</td>
                                    <td>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-success" style="width: 72%"></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <i class="bi bi-bag text-warning me-2"></i>
                                        Shopping
                                    </td>
                                    <td>67</td>
                                    <td>289</td>
                                    <td>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-success" style="width: 65%"></div>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
// User Growth Chart
const userGrowthCtx = document.getElementById('userGrowthChart').getContext('2d');
new Chart(userGrowthCtx, {
    type: 'line',
    data: {
        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        datasets: [{
            label: 'New Users',
            data: [120, 190, 300, 500, 700, 850, 1100, 1400, 1650, 1800, 2100, 2400],
            borderColor: 'rgb(102, 126, 234)',
            backgroundColor: 'rgba(102, 126, 234, 0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});

// User Type Chart
const userTypeCtx = document.getElementById('userTypeChart').getContext('2d');
new Chart(userTypeCtx, {
    type: 'doughnut',
    data: {
        labels: ['Regular Users', 'Business Owners', 'Admins'],
        datasets: [{
            data: [68, 28, 4],
            backgroundColor: ['rgb(102, 126, 234)', 'rgb(34, 197, 94)', 'rgb(251, 146, 60)']
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});

// Redemptions Chart
const redemptionsCtx = document.getElementById('redemptionsChart').getContext('2d');
new Chart(redemptionsCtx, {
    type: 'bar',
    data: {
        labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
        datasets: [{
            label: 'Redemptions',
            data: [450, 520, 480, 650, 780, 920, 850],
            backgroundColor: 'rgba(34, 197, 94, 0.8)'
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});

// Revenue Chart
const revenueCtx = document.getElementById('revenueChart').getContext('2d');
new Chart(revenueCtx, {
    type: 'line',
    data: {
        labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
        datasets: [{
            label: 'Revenue (AED)',
            data: [4500, 5200, 4800, 6500, 7800, 9200, 8500],
            borderColor: 'rgb(59, 130, 246)',
            backgroundColor: 'rgba(59, 130, 246, 0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});
</script>
@endsection
