@extends('layouts.admin')

@section('title', 'Business Report')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-shop"></i> Business Report
            </h1>
            <p class="text-muted">Business performance and metrics</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.analytics.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Analytics
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Period</label>
                    <select name="period" class="form-select" onchange="this.form.submit()">
                        <option value="7" {{ $period == 7 ? 'selected' : '' }}>Last 7 Days</option>
                        <option value="30" {{ $period == 30 ? 'selected' : '' }}>Last 30 Days</option>
                        <option value="90" {{ $period == 90 ? 'selected' : '' }}>Last 90 Days</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Sort By</label>
                    <select name="sort" class="form-select" onchange="this.form.submit()">
                        <option value="redemptions" {{ $sortBy == 'redemptions' ? 'selected' : '' }}>Redemptions</option>
                        <option value="rating" {{ $sortBy == 'rating' ? 'selected' : '' }}>Rating</option>
                        <option value="revenue" {{ $sortBy == 'revenue' ? 'selected' : '' }}>Revenue</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end gap-2">
                    <a href="{{ route('admin.analytics.reports.businesses') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-clockwise"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Businesses Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Business</th>
                        <th>Owner</th>
                        <th>Status</th>
                        <th>Venues</th>
                        <th>Staff</th>
                        <th>Offers</th>
                        <th>Redemptions</th>
                        <th>Rating</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($businesses as $business)
                        <tr>
                            <td>
                                <small>
                                    <strong>{{ Str::limit($business->business_name, 20) }}</strong><br>
                                    <span class="text-muted">{{ $business->email }}</span>
                                </small>
                            </td>
                            <td>
                                <small>{{ $business->owner->first_name ?? 'N/A' }}</small>
                            </td>
                            <td>
                                <span class="badge bg-{{ $business->status === 'verified' ? 'success' : ($business->status === 'active' ? 'info' : 'warning') }}">
                                    {{ ucfirst($business->status) }}
                                </span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">{{ $business->venues_count }}</span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">{{ $business->staff_count }}</span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">{{ $business->offers_count }}</span>
                            </td>
                            <td>
                                <span class="badge bg-success">{{ $business->redemptions_count }}</span>
                            </td>
                            <td>
                                <small>{{ number_format($business->reviews_avg_rating ?? 0, 1) }}/5</small>
                            </td>
                            <td>
                                <a href="{{ route('admin.businesses.show', $business) }}" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted py-4">
                                <small>No businesses found</small>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing {{ $businesses->firstItem() ?? 0 }} to {{ $businesses->lastItem() ?? 0 }} of {{ $businesses->total() }} businesses
                </small>
                {{ $businesses->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

