@extends('layouts.admin')

@section('title', 'Redemptions Report')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-check-circle"></i> Redemptions Report
            </h1>
            <p class="text-muted">Detailed redemption analytics and transactions</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.analytics.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Analytics
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Period</label>
                    <select name="period" class="form-select" onchange="this.form.submit()">
                        <option value="7" {{ $period == 7 ? 'selected' : '' }}>Last 7 Days</option>
                        <option value="30" {{ $period == 30 ? 'selected' : '' }}>Last 30 Days</option>
                        <option value="90" {{ $period == 90 ? 'selected' : '' }}>Last 90 Days</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select" onchange="this.form.submit()">
                        <option value="">All Statuses</option>
                        <option value="completed" {{ $status == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="pending" {{ $status == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="cancelled" {{ $status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-6 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search"></i> Filter
                    </button>
                    <a href="{{ route('admin.analytics.reports.redemptions') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-clockwise"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Redemptions Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Offer</th>
                        <th>Business</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($redemptions as $redemption)
                        <tr>
                            <td>
                                <small>
                                    <strong>{{ $redemption->user->first_name }} {{ $redemption->user->last_name }}</strong><br>
                                    <span class="text-muted">{{ $redemption->user->email }}</span>
                                </small>
                            </td>
                            <td>
                                <small>{{ Str::limit($redemption->offer->title, 25) }}</small>
                            </td>
                            <td>
                                <small class="text-muted">{{ $redemption->offer->business->business_name ?? 'N/A' }}</small>
                            </td>
                            <td>
                                <span class="badge bg-{{ $redemption->status === 'completed' ? 'success' : ($redemption->status === 'pending' ? 'warning' : 'danger') }}">
                                    {{ ucfirst($redemption->status) }}
                                </span>
                            </td>
                            <td>
                                <small class="text-muted">{{ $redemption->created_at->format('M d, Y H:i') }}</small>
                            </td>
                            <td>
                                <a href="#" class="btn btn-sm btn-info" title="View Details">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <small>No redemptions found</small>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing {{ $redemptions->firstItem() ?? 0 }} to {{ $redemptions->lastItem() ?? 0 }} of {{ $redemptions->total() }} redemptions
                </small>
                {{ $redemptions->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

