@extends('layouts.admin')

@section('title', 'User Report')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-people"></i> User Report
            </h1>
            <p class="text-muted">User growth and activity metrics</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.analytics.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Analytics
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Period</label>
                    <select name="period" class="form-select" onchange="this.form.submit()">
                        <option value="7" {{ $period == 7 ? 'selected' : '' }}>Last 7 Days</option>
                        <option value="30" {{ $period == 30 ? 'selected' : '' }}>Last 30 Days</option>
                        <option value="90" {{ $period == 90 ? 'selected' : '' }}>Last 90 Days</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Account Type</label>
                    <select name="account_type" class="form-select" onchange="this.form.submit()">
                        <option value="">All Users</option>
                        <option value="personal" {{ $accountType == 'personal' ? 'selected' : '' }}>Personal</option>
                        <option value="business" {{ $accountType == 'business' ? 'selected' : '' }}>Business</option>
                        <option value="admin" {{ $accountType == 'admin' ? 'selected' : '' }}>Admin</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end gap-2">
                    <a href="{{ route('admin.analytics.reports.users') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-clockwise"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Account Type</th>
                        <th>Status</th>
                        <th>Joined Date</th>
                        <th>Redemptions</th>
                        <th>Last Active</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($users as $user)
                        <tr>
                            <td>
                                <small>
                                    <strong>{{ $user->first_name }} {{ $user->last_name }}</strong>
                                </small>
                            </td>
                            <td>
                                <small class="text-muted">{{ $user->email }}</small>
                            </td>
                            <td>
                                <span class="badge bg-{{ $user->account_type === 'business' ? 'info' : ($user->account_type === 'admin' ? 'danger' : 'secondary') }}">
                                    {{ ucfirst($user->account_type) }}
                                </span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $user->status === 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($user->status) }}
                                </span>
                            </td>
                            <td>
                                <small class="text-muted">{{ $user->created_at->format('M d, Y') }}</small>
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $user->redemptions_count }}</span>
                            </td>
                            <td>
                                <small class="text-muted">
                                    {{ $user->updated_at->diffForHumans() }}
                                </small>
                            </td>
                            <td>
                                <a href="{{ route('admin.users.show', $user) }}" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                <small>No users found</small>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing {{ $users->firstItem() ?? 0 }} to {{ $users->lastItem() ?? 0 }} of {{ $users->total() }} users
                </small>
                {{ $users->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

