@extends('layouts.admin')
@section('title', 'Create Business for User')
@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h1>Create Business for {{ $user->first_name }}</h1>
            </div>
            <div class="card-body">
                <p>Please fill in the details below to create a new business for the user.</p>
                <form action="{{ route('admin.businesses.store-for-user', $user->id) }}" method="POST">
                    @csrf
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Business Name (English) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="business_name" id="businessName" value="{{ old('business_name') }}" required>
                            <small class="text-success" id="nameAvailable" style="display: none;">
                                <i class="bi bi-check-circle"></i> Available
                            </small>
                            <small class="text-danger" id="nameUnavailable" style="display: none;">
                                <i class="bi bi-x-circle"></i> Already taken
                            </small>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Business Name (Arabic)</label>
                            <input type="text" class="form-control" name="business_name_ar" value="{{ old('business_name_ar') }}" dir="rtl">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Trade License Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="trade_license_number" id="licenseNumber" value="{{ old('trade_license_number') }}" required>
                            <small class="text-success" id="licenseAvailable" style="display: none;">
                                <i class="bi bi-check-circle"></i> Available
                            </small>
                            <small class="text-danger" id="licenseUnavailable" style="display: none;">
                                <i class="bi bi-x-circle"></i> Already registered
                            </small>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Business Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" name="email" value="{{ old('email') }}" required>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Business Phone <span class="text-danger">*</span></label>
                            <input type="tel" class="form-control" name="phone" value="{{ old('phone') }}" required>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Website</label>
                            <input type="url" class="form-control" name="website" value="{{ old('website') }}" placeholder="https://example.com">
                        </div>

                        <div class="col-12">
                            <label class="form-label">Business Description (English)</label>
                            <textarea class="form-control" name="description" rows="3">{{ old('description') }}</textarea>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Business Description (Arabic)</label>
                            <textarea class="form-control" name="description_ar" rows="3" dir="rtl">{{ old('description_ar') }}</textarea>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Trade License Document <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" name="trade_license_document" accept=".pdf,.jpg,.jpeg,.png" required>
                            <small class="text-muted">PDF, JPG, or PNG (Max 5MB)</small>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Business Logo</label>
                            <input type="file" class="form-control" name="logo" accept="image/*" onchange="previewImage(this, 'logoPreview')">
                            <small class="text-muted">PNG or JPG (Max 2MB)</small>
                            <div class="mt-2">
                                <img id="logoPreview" src="" style="max-width: 150px; display: none;" class="img-thumbnail">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Cover Image</label>
                            <input type="file" class="form-control" name="cover_image" accept="image/*" onchange="previewImage(this, 'coverPreview')">
                            <small class="text-muted">PNG or JPG (Max 2MB)</small>
                            <div class="mt-2">
                                <img id="coverPreview" src="" style="max-width: 150px; display: none;" class="img-thumbnail">
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="termsCheck" required>
                                <label class="form-check-label" for="termsCheck">
                                    I agree to the <a href="#" target="_blank">Terms & Conditions</a> and <a href="#" target="_blank">Privacy Policy</a>
                                </label>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Create Business</button>
                </form>
            </div>
        </div>

    </div>
    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                }
                reader.readAsDataURL(input.files[0]);
            } else {
                preview.src = '';
                preview.style.display = 'none';
            }
        }

        document.getElementById('businessName').addEventListener('blur', function() {
            const name = this.value;
            fetch(`/admin/businesses/check-name?name=${encodeURIComponent(name)}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('nameAvailable').style.display = data.available ? 'inline' : 'none';
                    document.getElementById('nameUnavailable').style.display = data.available ? 'none' : 'inline';
                });
        });

        document.getElementById('licenseNumber').addEventListener('blur', function() {
            const licenseNumber = this.value;
            fetch(`/admin/businesses/check-license?license_number=${encodeURIComponent(licenseNumber)}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('licenseAvailable').style.display = data.available ? 'inline' : 'none';
                    document.getElementById('licenseUnavailable').style.display = data.available ? 'none' : 'inline';
                });
        });
    </script>
@endsection
