@extends('layouts.admin')

@section('title', 'Businesses Management')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-building me-2"></i>Businesses Management
            </h1>
            <p class="text-muted">Manage all registered businesses and their information</p>
        </div>
        <div class="col-md-4 text-end">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createBusinessModal">
                <i class="fas fa-plus me-2"></i>Add New Business
            </button>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small mb-1">Total Businesses</p>
                            <h3 class="mb-0">{{ $totalBusinesses }}</h3>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-store text-primary fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small mb-1">Verified</p>
                            <h3 class="mb-0">{{ $verifiedBusinesses }}</h3>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-check-circle text-success fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small mb-1">Pending Review</p>
                            <h3 class="mb-0">{{ $pendingBusinesses }}</h3>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-hourglass text-warning fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small mb-1">Rejected</p>
                            <h3 class="mb-0">{{ $rejectedBusinesses }}</h3>
                        </div>
                        <div class="bg-danger bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-times-circle text-danger fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label small fw-bold">Search</label>
                    <input type="text" class="form-control" id="searchInput" placeholder="Business name, owner, email...">
                </div>
                <div class="col-md-3">
                    <label class="form-label small fw-bold">Verification Status</label>
                    <select class="form-select" id="statusFilter">
                        <option value="">All Status</option>
                        <option value="verified">Verified</option>
                        <option value="pending">Pending</option>
                        <option value="rejected">Rejected</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label small fw-bold">Subscription</label>
                    <select class="form-select" id="subscriptionFilter">
                        <option value="">All Plans</option>
                        <option value="free">Free</option>
                        <option value="paid">Paid</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button class="btn btn-outline-secondary w-100" onclick="resetFilters()">
                        <i class="fas fa-redo me-1"></i>Reset
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Businesses Table -->
    <div class="card shadow-sm border-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light border-bottom">
                    <tr>
                        <th>Business</th>
                        <th>Owner</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Plan</th>
                        <th>Status</th>
                        <th>Venues</th>
                        <th>Registered</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($businesses as $business)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="{{ $business->logo_url ?? 'https://via.placeholder.com/40' }}"
                                     class="rounded me-3" width="40" height="40" alt="{{ $business->business_name }}">
                                <div>
                                    <p class="fw-bold mb-0">{{ $business->business_name }}</p>
                                    <small class="text-muted">ID: {{ $business->id }}</small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <p class="mb-0">{{ $business->owner->name ?? '-' }}</p>
                            <small class="text-muted">{{ $business->owner->email ?? '-' }}</small>
                        </td>
                        <td>{{ $business->email }}</td>
                        <td>{{ $business->phone }}</td>
                        <td>
                            @if($business->subscription)
                            <span class="badge bg-primary">{{ $business->subscription->plan->name }}</span>
                            @else
                            <span class="badge bg-secondary">Free</span>
                            @endif
                        </td>
                        <td>
                            @if($business->verification_status === 'verified')
                            <span class="badge bg-success">Verified</span>
                            @elseif($business->verification_status === 'pending')
                            <span class="badge bg-warning">Pending</span>
                            @else
                            <span class="badge bg-danger">Rejected</span>
                            @endif
                        </td>
                        <td>
                            <small>{{ $business->venues_count ?? 0 }}</small>
                        </td>
                        <td>
                            <small class="text-muted">{{ $business->created_at->format('M d, Y') }}</small>
                        </td>
                        <td class="text-end pe-4">
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.businesses.show', $business->id) }}" class="btn btn-outline-primary" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button class="btn btn-outline-secondary" onclick="editBusiness({{ $business->id }})" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </button>
                                @if($business->verification_status === 'pending')
                                <button class="btn btn-outline-success btn-sm" onclick="approveBusiness({{ $business->id }})" title="Approve">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button class="btn btn-outline-danger btn-sm" onclick="rejectBusiness({{ $business->id }})" title="Reject">
                                    <i class="fas fa-times"></i>
                                </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center py-5">
                            <i class="fas fa-inbox text-muted" style="font-size: 48px;"></i>
                            <p class="text-muted mt-3">No businesses found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <p class="text-muted small mb-0">Showing {{ $businesses->count() }} of {{ $totalBusinesses }} businesses</p>
                {{ $businesses->links() }}
            </div>
        </div>
    </div>
</div>

<!-- Edit Business Modal -->
<div class="modal fade" id="editBusinessModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold">Edit Business</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="editBusinessForm">
                @csrf
                <input type="hidden" id="editBusinessId" name="id">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Business Name</label>
                            <input type="text" class="form-control" id="editBusinessName" name="business_name" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" id="editBusinessEmail" name="email" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Phone</label>
                            <input type="tel" class="form-control" id="editBusinessPhone" name="phone">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">License Number</label>
                            <input type="text" class="form-control" id="editLicense" name="license_number">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Address</label>
                            <textarea class="form-control" id="editAddress" name="address" rows="2"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editBusiness(id) {
    fetch(`/admin/businesses/${id}`)
        .then(r => r.json())
        .then(data => {
            document.getElementById('editBusinessId').value = data.business.id;
            document.getElementById('editBusinessName').value = data.business.business_name;
            document.getElementById('editBusinessEmail').value = data.business.email;
            document.getElementById('editBusinessPhone').value = data.business.phone || '';
            document.getElementById('editLicense').value = data.business.license_number || '';
            document.getElementById('editAddress').value = data.business.address || '';
            new bootstrap.Modal(document.getElementById('editBusinessModal')).show();
        });
}

function approveBusiness(id) {
    if(confirm('Approve this business?')) {
        fetch(`/admin/businesses/${id}/approve`, {method: 'POST', headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'}})
            .then(r => r.json())
            .then(d => {if(d.success) location.reload();});
    }
}

function rejectBusiness(id) {
    const reason = prompt('Enter rejection reason:');
    if(reason) {
        fetch(`/admin/businesses/${id}/reject`, {
            method: 'POST',
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type': 'application/json'},
            body: JSON.stringify({reason})
        })
            .then(r => r.json())
            .then(d => {if(d.success) location.reload();});
    }
}

function resetFilters() {
    document.getElementById('searchInput').value = '';
    document.getElementById('statusFilter').value = '';
    document.getElementById('subscriptionFilter').value = '';
}
</script>
@endsection

