@extends('layouts.admin')

@section('title', $category->name)

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">{{ $category->name }}</h1>
            <p class="text-muted">{{ $category->name_ar }}</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.categories.edit', $category) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Icon</h6>
                </div>
                <div class="card-body text-center">
                    @if($category->icon)
                        <img src="{{ Storage::url($category->icon) }}"
                            alt="{{ $category->name }}"
                            class="img-fluid"
                            style="width: 150px; height: 150px;">
                    @else
                        <span class="text-muted">No icon</span>
                    @endif
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Information</h6>
                </div>
                <div class="card-body">
                    <p class="mb-2">
                        <strong>Slug:</strong><br>
                        <small class="text-muted">{{ $category->slug }}</small>
                    </p>
                    <p class="mb-2">
                        <strong>Status:</strong><br>
                        <span class="badge bg-{{ $category->is_active ? 'success' : 'secondary' }}">
                            {{ $category->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </p>
                    <p class="mb-2">
                        <strong>Created:</strong><br>
                        <small>{{ $category->created_at->format('M d, Y H:i') }}</small>
                    </p>
                    <p class="mb-0">
                        <strong>Updated:</strong><br>
                        <small>{{ $category->updated_at->format('M d, Y H:i') }}</small>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Description</h6>
                </div>
                <div class="card-body">
                    <h6 class="mb-2">English</h6>
                    <p class="mb-4">{{ $category->description ?? 'No description' }}</p>

                    <h6 class="mb-2">Arabic</h6>
                    <p class="mb-0" dir="rtl">{{ $category->description_ar ?? 'No description' }}</p>
                </div>
            </div>

            @if($category->children->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Subcategories</h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($category->children as $child)
                            <tr>
                                <td><strong>{{ $child->name }}</strong></td>
                                <td><small class="text-muted">{{ $child->slug }}</small></td>
                                <td>
                                    <span class="badge bg-{{ $child->is_active ? 'success' : 'secondary' }}">
                                        {{ $child->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('admin.categories.show', $child) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif

            @if($venues->count() > 0)
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Venues in this Category</h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Venue Name</th>
                                <th>Business</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($venues as $venue)
                            <tr>
                                <td><strong>{{ $venue->name }}</strong></td>
                                <td>{{ $venue->business->business_name ?? 'N/A' }}</td>
                                <td>
                                    <span class="badge bg-{{ $venue->status === 'active' ? 'success' : 'secondary' }}">
                                        {{ ucfirst($venue->status) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('admin.venues.show', $venue) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

