@extends('layouts.admin')

@section('title', 'Admin Chat Management')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-comments"></i> Chats Management
            </h1>
            <p class="text-muted">Monitor and manage all chats and conversations</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Chats</h6>
                    <h3 class="mb-0">{{ $stats['total'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active</h6>
                    <h3 class="mb-0">{{ $stats['active'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Messages</h6>
                    <h3 class="mb-0">{{ $stats['messages'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Users</h6>
                    <h3 class="mb-0">{{ $stats['active_users'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search chats..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select form-select-sm">
                        <option value="">All Types</option>
                        <option value="team" {{ request('type') === 'team' ? 'selected' : '' }}>Team</option>
                        <option value="business" {{ request('type') === 'business' ? 'selected' : '' }}>Business</option>
                        <option value="direct" {{ request('type') === 'direct' ? 'selected' : '' }}>Direct</option>
                        <option value="group" {{ request('type') === 'group' ? 'selected' : '' }}>Group</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Chats Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Chat Name</th>
                        <th>Type</th>
                        <th>Members</th>
                        <th>Messages</th>
                        <th>Status</th>
                        <th>Last Message</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($chats))
                    @forelse($chats as $chat)
                    <tr>
                        <td>
                            <strong>{{ $chat->name ?? 'N/A' }}</strong>
                            <br>
                            <small class="text-muted">{{ Str::limit($chat->description ?? '', 40) }}</small>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($chat->type ?? 'direct') }}</span>
                        </td>
                        <td>
                            {{ $chat->participants_count ?? 0 }}
                        </td>
                        <td>
                            {{ $chat->message_count ?? 0 }}
                        </td>
                        <td>
                            <span class="badge bg-{{ $chat->is_active ? 'success' : 'secondary' }}">
                                {{ $chat->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>
                            @if($chat->last_message_at)
                                <small>{{ $chat->last_message_at->diffForHumans() }}</small>
                            @else
                                <small class="text-muted">Never</small>
                            @endif
                        </td>
                        <td>
                            <small>{{ $chat->created_at ? $chat->created_at->format('M d, Y') : 'N/A' }}</small>
                        </td>
                        <td>
                            <a href="{{ route('admin.chats.show', $chat->id) }}" class="btn btn-sm btn-info" title="View Messages">
                                <i class="fas fa-eye"></i>
                            </a>
                            @if($chat->is_active)
                            <form action="{{ route('admin.chats.disable', $chat->id) }}" method="POST" style="display:inline;">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-warning" title="Disable Chat" onclick="return confirm('Disable this chat?')">
                                    <i class="fas fa-ban"></i>
                                </button>
                            </form>
                            @else
                            <form action="{{ route('admin.chats.enable', $chat->id) }}" method="POST" style="display:inline;">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-success" title="Enable Chat" onclick="return confirm('Enable this chat?')">
                                    <i class="fas fa-check"></i>
                                </button>
                            </form>
                            @endif
                            <form action="{{ route('admin.chats.destroy', $chat->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" title="Delete Chat" onclick="return confirm('Delete this chat permanently?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No chats found.
                        </td>
                    </tr>
                    @endforelse
                    @else
                    <tr>
                        <td colspan="8" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load chats
                        </td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            @if(isset($chats) && method_exists($chats, 'total'))
            Showing {{ $chats->firstItem() ?? 0 }} to {{ $chats->lastItem() ?? 0 }} of {{ $chats->total() }} chats
            @else
            No data available
            @endif
        </div>
        <div>
            @if(isset($chats) && method_exists($chats, 'hasPages') && $chats->hasPages())
            {{ $chats->links() }}
            @endif
        </div>
    </div>
</div>
@endsection

