@extends('layouts.admin')

@section('title', 'Chat Details - ' . ($chat->name ?? 'Chat'))

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-comments"></i> {{ $chat->name ?? 'Chat Details' }}
            </h1>
            <p class="text-muted">View and manage chat messages</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.chats.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Chats
            </a>
        </div>
    </div>

    <!-- Chat Information -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Chat Type</h6>
                    <p class="mb-0"><span class="badge bg-info">{{ ucfirst($chat->type) }}</span></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Status</h6>
                    <p class="mb-0">
                        <span class="badge bg-{{ $chat->is_active ? 'success' : 'danger' }}">
                            {{ $chat->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Messages</h6>
                    <p class="mb-0"><strong>{{ $chat->messages_count ?? 0 }}</strong></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Participants -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-users"></i> Participants ({{ $chat->participants_count ?? 0 }})
            </h5>
        </div>
        <div class="table-responsive">
            <table class="table table-sm mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Joined</th>
                        <th>Last Read</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($chat->participants as $participant)
                    <tr>
                        <td>
                            <strong>{{ $participant->first_name }} {{ $participant->last_name }}</strong>
                        </td>
                        <td>{{ $participant->email }}</td>
                        <td>
                            @if($participant->pivot && $participant->pivot->joined_at)
                                @if(is_string($participant->pivot->joined_at))
                                    {{ \Carbon\Carbon::parse($participant->pivot->joined_at)->format('M d, Y H:i') }}
                                @else
                                    {{ $participant->pivot->joined_at->format('M d, Y H:i') }}
                                @endif
                            @else
                                N/A
                            @endif
                        </td>
                        <td>
                            @if($participant->pivot && $participant->pivot->last_read_at)
                                @if(is_string($participant->pivot->last_read_at))
                                    {{ \Carbon\Carbon::parse($participant->pivot->last_read_at)->diffForHumans() }}
                                @else
                                    {{ $participant->pivot->last_read_at->diffForHumans() }}
                                @endif
                            @else
                                Never
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">No participants</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Messages -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-envelope"></i> Messages
            </h5>
        </div>
        <div class="card-body" style="max-height: 500px; overflow-y: auto;">
            @forelse($messages as $message)
            <div class="mb-3 pb-3 border-bottom">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <strong>{{ $message->sender->first_name }} {{ $message->sender->last_name }}</strong>
                        <span class="text-muted small">{{ $message->sender->email }}</span>
                    </div>
                    <small class="text-muted">
                        @if(is_string($message->created_at))
                            {{ \Carbon\Carbon::parse($message->created_at)->format('M d, Y H:i') }}
                        @else
                            {{ $message->created_at->format('M d, Y H:i') }}
                        @endif
                        @if($message->is_edited)
                            <span class="badge bg-warning">Edited</span>
                        @endif
                    </small>
                </div>
                <p class="mb-0 mt-2">{{ $message->content }}</p>
                <small class="text-muted">
                    Type: <span class="badge bg-secondary">{{ ucfirst($message->message_type) }}</span>
                </small>
            </div>
            @empty
            <div class="text-center text-muted py-4">
                <i class="fas fa-inbox fs-1 d-block mb-2"></i>
                <p>No messages in this chat</p>
            </div>
            @endforelse
        </div>

        <!-- Pagination -->
        @if($messages->hasPages())
        <div class="card-footer">
            <nav>
                <ul class="pagination pagination-sm mb-0">
                    <!-- Previous Page -->
                    @if ($messages->onFirstPage())
                        <li class="page-item disabled">
                            <span class="page-link">← Previous</span>
                        </li>
                    @else
                        <li class="page-item">
                            <a class="page-link" href="{{ $messages->previousPageUrl() }}">← Previous</a>
                        </li>
                    @endif

                    <!-- Page Numbers -->
                    @foreach ($messages->getUrlRange(1, $messages->lastPage()) as $page => $url)
                        @if ($page == $messages->currentPage())
                            <li class="page-item active">
                                <span class="page-link">{{ $page }}</span>
                            </li>
                        @else
                            <li class="page-item">
                                <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                            </li>
                        @endif
                    @endforeach

                    <!-- Next Page -->
                    @if ($messages->hasMorePages())
                        <li class="page-item">
                            <a class="page-link" href="{{ $messages->nextPageUrl() }}">Next →</a>
                        </li>
                    @else
                        <li class="page-item disabled">
                            <span class="page-link">Next →</span>
                        </li>
                    @endif
                </ul>
            </nav>
        </div>
        @endif
    </div>

    <!-- Actions -->
    <div class="mt-4">
        @if($chat->is_active)
        <form action="{{ route('admin.chats.disable', $chat->id) }}" method="POST" style="display:inline;">
            @csrf
            <button type="submit" class="btn btn-warning" onclick="return confirm('Disable this chat?')">
                <i class="fas fa-ban"></i> Disable Chat
            </button>
        </form>
        @else
        <form action="{{ route('admin.chats.enable', $chat->id) }}" method="POST" style="display:inline;">
            @csrf
            <button type="submit" class="btn btn-success" onclick="return confirm('Enable this chat?')">
                <i class="fas fa-check"></i> Enable Chat
            </button>
        </form>
        @endif

        <form action="{{ route('admin.chats.destroy', $chat->id) }}" method="POST" style="display:inline;">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger" onclick="return confirm('Delete this chat permanently?')">
                <i class="fas fa-trash"></i> Delete Chat
            </button>
        </form>
    </div>
</div>
@endsection

