<!-- Admin Sidebar Component - Professional Design -->
<aside class="admin-sidebar">
    <!-- Logo & Branding Section -->
    <div class="sidebar-brand">
        <div class="brand-logo">
            <i class="fas fa-shield-check"></i>
        </div>
        <div class="brand-text">
            <h4 class="brand-title">Privasee</h4>
            <span class="brand-subtitle">Admin</span>
        </div>
    </div>

    <!-- User Profile Section -->
    @if(auth()->check())
    <div class="sidebar-user">
        <div class="user-avatar">
            <img src="https://ui-avatars.com/api/?name={{ auth()->user()->first_name ?? 'A' }}&background=0d6efd&color=fff"
                 alt="User Avatar" class="avatar-img">
            <span class="user-status online"></span>
        </div>
        <div class="user-info">
            <div class="user-name">{{ auth()->user()->first_name ?? 'Admin' }} {{ auth()->user()->last_name ?? '' }}</div>
            <div class="user-role">
                @if(auth()->user()->hasRole('super_admin'))
                    <span class="badge badge-role super-admin">Super Admin</span>
                @elseif(auth()->user()->hasRole('admin'))
                    <span class="badge badge-role admin">Admin</span>
                @else
                    <span class="badge badge-role">Manager</span>
                @endif
            </div>
        </div>
    </div>
    @endif

    <!-- Main Navigation -->
    <nav class="sidebar-nav">
        @php
            $menuItems = \App\Helpers\AdminHelper::getAdminMenuItems();
        @endphp

        @if(count($menuItems) > 0)
            <!-- Main Menu Items -->
            <div class="nav-section">
                <div class="nav-section-label">Main Menu</div>

                @foreach($menuItems as $item)
                    @if(isset($item['submenu']) && count($item['submenu']) > 0)
                        <!-- Menu Group with Submenu -->
                        <div class="nav-item-group">
                            <button class="nav-item-toggle {{ $item['active'] ? 'active' : '' }}"
                                type="button"
                                data-bs-toggle="collapse"
                                data-bs-target="#submenu-{{ \Illuminate\Support\Str::slug($item['title']) }}">
                                <div class="nav-item-icon">
                                    <i class="{{ $item['icon'] }}"></i>
                                </div>
                                <span class="nav-item-text">{{ $item['title'] }}</span>
                                <div class="nav-item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </button>

                            <div class="collapse {{ $item['active'] ? 'show' : '' }}"
                                id="submenu-{{ \Illuminate\Support\Str::slug($item['title']) }}">
                                <div class="nav-submenu">
                                    @foreach($item['submenu'] as $subitem)
                                        <a class="nav-subitem {{ $subitem['active'] ? 'active' : '' }}"
                                            href="{{ $subitem['url'] }}">
                                            <span class="nav-subitem-dot"></span>
                                            <span class="nav-subitem-text">{{ $subitem['title'] }}</span>
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @else
                        <!-- Simple Menu Item -->
                        <a class="nav-item {{ $item['active'] ? 'active' : '' }}"
                            href="{{ $item['url'] }}">
                            <div class="nav-item-icon">
                                <i class="{{ $item['icon'] }}"></i>
                            </div>
                            <span class="nav-item-text">{{ $item['title'] }}</span>
                            @if(isset($item['badge']))
                                <span class="nav-item-badge">{{ $item['badge'] }}</span>
                            @endif
                        </a>
                    @endif
                @endforeach
            </div>
        @else
            <div class="nav-empty">
                <i class="fas fa-lock"></i>
                <p>No items available</p>
            </div>
        @endif
    </nav>

    <!-- Divider -->
    <div class="sidebar-divider"></div>

    <!-- Footer Navigation -->
    <nav class="sidebar-footer">
        <!-- Settings -->
        @if(\App\Helpers\AdminHelper::can('admin.settings'))
            @if(Route::has('admin.settings.index'))
            <a class="nav-item" href="{{ route('admin.settings.index') }}" title="Settings">
                <div class="nav-item-icon">
                    <i class="fas fa-cog"></i>
                </div>
                <span class="nav-item-text">Settings</span>
            </a>
            @endif
        @endif

        <!-- Profile -->
        @if(Route::has('admin.profile.edit'))
        <a class="nav-item" href="{{ route('admin.profile.edit') }}" title="My Profile">
            <div class="nav-item-icon">
                <i class="fas fa-user-circle"></i>
            </div>
            <span class="nav-item-text">Profile</span>
        </a>
        @endif

        <!-- Logout -->
        <form method="POST" action="{{ route('logout') }}" class="nav-item-form">
            @csrf
            <button type="submit" class="nav-item nav-logout" title="Logout">
                <div class="nav-item-icon">
                    <i class="fas fa-power-off"></i>
                </div>
                <span class="nav-item-text">Logout</span>
            </button>
        </form>
    </nav>
</aside>

<style>
    /* ============= Admin Sidebar Styles ============= */
    .admin-sidebar {
        position: fixed;
        left: 0;
        top: 0;
        width: 280px;
        height: 100vh;
        background: linear-gradient(135deg, #0f172a 0%, #1a2942 100%);
        color: #e2e8f0;
        display: flex;
        flex-direction: column;
        z-index: 1000;
        box-shadow: 2px 0 15px rgba(0, 0, 0, 0.3);
        overflow-y: auto;
        overflow-x: hidden;
    }

    /* ============= Sidebar Brand ============= */
    .sidebar-brand {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 24px 20px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        min-height: 90px;
    }

    .brand-logo {
        width: 48px;
        height: 48px;
        background: linear-gradient(135deg, #0d6efd 0%, #0857ca 100%);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        flex-shrink: 0;
    }

    .brand-text {
        flex: 1;
    }

    .brand-title {
        font-size: 18px;
        font-weight: 700;
        margin: 0;
        color: white;
        letter-spacing: 0.5px;
    }

    .brand-subtitle {
        font-size: 11px;
        font-weight: 600;
        color: #0d6efd;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    /* ============= Sidebar User ============= */
    .sidebar-user {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 16px 20px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        background: rgba(13, 110, 253, 0.05);
    }

    .user-avatar {
        position: relative;
        flex-shrink: 0;
    }

    .avatar-img {
        width: 44px;
        height: 44px;
        border-radius: 10px;
        border: 2px solid rgba(13, 110, 253, 0.3);
    }

    .user-status {
        position: absolute;
        bottom: 0;
        right: 0;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 2px solid #0f172a;
    }

    .user-status.online {
        background-color: #10b981;
    }

    .user-info {
        flex: 1;
        min-width: 0;
    }

    .user-name {
        font-size: 14px;
        font-weight: 600;
        color: white;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .user-role {
        margin-top: 4px;
    }

    .badge-role {
        font-size: 10px;
        font-weight: 600;
        padding: 4px 8px;
        border-radius: 4px;
        background: rgba(13, 110, 253, 0.2);
        color: #93c5fd;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .badge-role.super-admin {
        background: rgba(239, 68, 68, 0.2);
        color: #fca5a5;
    }

    .badge-role.admin {
        background: rgba(59, 130, 246, 0.2);
        color: #93c5fd;
    }

    /* ============= Navigation Sections ============= */
    .sidebar-nav {
        flex: 1;
        overflow-y: auto;
        padding: 16px 0;
    }

    .nav-section {
        padding: 12px 0;
    }

    .nav-section-label {
        font-size: 11px;
        font-weight: 700;
        color: #64748b;
        text-transform: uppercase;
        letter-spacing: 1px;
        padding: 12px 20px;
        margin-bottom: 8px;
    }

    /* ============= Navigation Items ============= */
    .nav-item,
    .nav-item-toggle {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 12px 20px;
        margin: 0 10px;
        border-radius: 8px;
        border: none;
        background: transparent;
        color: #cbd5e1;
        text-decoration: none;
        cursor: pointer;
        transition: all 0.3s ease;
        width: calc(100% - 20px);
        text-align: left;
        font-size: 14px;
        font-weight: 500;
    }

    .nav-item:hover,
    .nav-item-toggle:hover {
        background: rgba(255, 255, 255, 0.1);
        color: white;
    }

    .nav-item.active,
    .nav-item-toggle.active {
        background: rgba(13, 110, 253, 0.2);
        color: #93c5fd;
        border-left: 3px solid #0d6efd;
        padding-left: 17px;
    }

    .nav-item-icon {
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
        flex-shrink: 0;
    }

    .nav-item-text {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .nav-item-badge {
        background: #0d6efd;
        color: white;
        font-size: 10px;
        padding: 2px 6px;
        border-radius: 4px;
        font-weight: 600;
        white-space: nowrap;
    }

    .nav-item-arrow {
        font-size: 12px;
        margin-left: auto;
        transition: transform 0.3s ease;
        color: #94a3b8;
    }

    .nav-item-toggle[aria-expanded="true"] .nav-item-arrow {
        transform: rotate(90deg);
        color: #0d6efd;
    }

    /* ============= Submenu ============= */
    .nav-item-group {
        display: contents;
    }

    .nav-submenu {
        padding: 8px 0;
        background: rgba(0, 0, 0, 0.2);
        margin: 4px 10px;
        border-radius: 6px;
    }

    .nav-subitem {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 10px 20px;
        margin: 0 8px;
        color: #cbd5e1;
        text-decoration: none;
        font-size: 13px;
        border-radius: 6px;
        transition: all 0.3s ease;
    }

    .nav-subitem:hover {
        background: rgba(255, 255, 255, 0.05);
        color: white;
        padding-left: 24px;
    }

    .nav-subitem.active {
        background: rgba(13, 110, 253, 0.15);
        color: #93c5fd;
    }

    .nav-subitem-dot {
        width: 6px;
        height: 6px;
        background: currentColor;
        border-radius: 50%;
        flex-shrink: 0;
    }

    .nav-subitem-text {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    /* ============= Sidebar Divider ============= */
    .sidebar-divider {
        height: 1px;
        background: rgba(255, 255, 255, 0.1);
        margin: 12px 0;
    }

    /* ============= Sidebar Footer ============= */
    .sidebar-footer {
        padding: 12px 0 16px;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
    }

    .nav-item-form {
        display: contents;
    }

    .nav-logout {
        color: #ef4444;
    }

    .nav-logout:hover {
        background: rgba(239, 68, 68, 0.1) !important;
        color: #fca5a5;
    }

    /* ============= Empty State ============= */
    .nav-empty {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
        color: #64748b;
        text-align: center;
    }

    .nav-empty i {
        font-size: 32px;
        margin-bottom: 12px;
        opacity: 0.5;
    }

    .nav-empty p {
        font-size: 13px;
        margin: 0;
    }

    /* ============= Scrollbar ============= */
    .admin-sidebar::-webkit-scrollbar {
        width: 6px;
    }

    .admin-sidebar::-webkit-scrollbar-track {
        background: transparent;
    }

    .admin-sidebar::-webkit-scrollbar-thumb {
        background: rgba(255, 255, 255, 0.2);
        border-radius: 3px;
    }

    .admin-sidebar::-webkit-scrollbar-thumb:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    /* ============= Responsive ============= */
    @media (max-width: 992px) {
        .admin-sidebar {
            width: 260px;
        }

        .nav-item-text,
        .nav-subitem-text {
            font-size: 13px;
        }
    }

    @media (max-width: 768px) {
        .admin-sidebar {
            position: fixed;
            left: -280px;
            transition: left 0.3s ease;
            width: 280px;
            height: 100vh;
        }

        .admin-sidebar.show {
            left: 0;
        }
    }
</style>

