@extends('layouts.admin')

@section('title', 'Create Marketing Campaign')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-plus me-2"></i>Create Marketing Campaign
            </h1>
            <p class="text-muted">Create a new campaign for a business</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.marketing.campaigns.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Campaigns
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-light py-3">
                    <h5 class="mb-0 fw-bold">Campaign Information</h5>
                </div>
                <div class="card-body p-4">
                    <form action="{{ route('admin.marketing.campaigns.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <!-- Business Selection -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Business <span class="text-danger">*</span></label>
                            <select name="business_id" class="form-select @error('business_id') is-invalid @enderror" required>
                                <option value="">Select Business</option>
                                @foreach($businesses as $business)
                                <option value="{{ $business->id }}" {{ old('business_id') == $business->id ? 'selected' : '' }}>
                                    {{ $business->business_name }}
                                </option>
                                @endforeach
                            </select>
                            @error('business_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Campaign Name -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Campaign Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                   value="{{ old('name') }}" required>
                            @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description <span class="text-danger">*</span></label>
                            <textarea name="description" class="form-control @error('description') is-invalid @enderror"
                                      rows="3" required>{{ old('description') }}</textarea>
                            @error('description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Campaign Type -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Type <span class="text-danger">*</span></label>
                            <select name="type" class="form-select @error('type') is-invalid @enderror" required>
                                <option value="">Select Type</option>
                                <option value="banner" {{ old('type') === 'banner' ? 'selected' : '' }}>Banner</option>
                                <option value="spotlight" {{ old('type') === 'spotlight' ? 'selected' : '' }}>Spotlight</option>
                            </select>
                            @error('type')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Banner Image -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Banner Image <span class="text-danger">*</span></label>
                            <input type="file" name="banner_image" class="form-control @error('banner_image') is-invalid @enderror"
                                   accept="image/*" required>
                            <small class="form-text text-muted">Recommended: 1200x300px. Max 5MB</small>
                            @error('banner_image')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Date Range -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Start Date <span class="text-danger">*</span></label>
                                <input type="datetime-local" name="start_date" class="form-control @error('start_date') is-invalid @enderror"
                                       value="{{ old('start_date') }}" required>
                                @error('start_date')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">End Date <span class="text-danger">*</span></label>
                                <input type="datetime-local" name="end_date" class="form-control @error('end_date') is-invalid @enderror"
                                       value="{{ old('end_date') }}" required>
                                @error('end_date')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>

                        <!-- Budget -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Budget (AED) <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" name="budget" class="form-control @error('budget') is-invalid @enderror"
                                       value="{{ old('budget') }}" required>
                                @error('budget')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Currency</label>
                                <select name="currency" class="form-select">
                                    <option value="AED" selected>AED</option>
                                    <option value="USD">USD</option>
                                    <option value="EUR">EUR</option>
                                </select>
                            </div>
                        </div>

                        <!-- Status (Admin Only) -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Status <span class="text-danger">*</span></label>
                            <select name="status" class="form-select @error('status') is-invalid @enderror" required>
                                <option value="pending" {{ old('status') === 'pending' ? 'selected' : '' }}>Pending Review</option>
                                <option value="approved" {{ old('status') === 'approved' ? 'selected' : '' }}>Approved</option>
                                <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>Active</option>
                            </select>
                            @error('status')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Submit -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Create Campaign
                            </button>
                            <a href="{{ route('admin.marketing.campaigns.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Info Sidebar -->
        <div class="col-lg-4">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-light py-3">
                    <h6 class="mb-0 fw-bold">Campaign Guidelines</h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled small">
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Select appropriate business
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Upload quality banner images
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Set valid date ranges
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Define clear goals
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

