@extends('layouts.admin')

@section('title', 'Campaign Details')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">{{ $campaign->name }}</h1>
            <p class="text-muted">Campaign Details & Performance</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.marketing.campaigns') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <!-- Campaign Status -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Status</p>
                            <h5 class="mb-0">
                                <span class="badge bg-{{ $campaign->status === 'active' ? 'success' : ($campaign->status === 'pending' ? 'warning' : ($campaign->status === 'approved' ? 'info' : 'secondary')) }}">
                                    {{ ucfirst($campaign->status) }}
                                </span>
                            </h5>
                        </div>
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Duration</p>
                            <h5 class="mb-0">{{ $campaign->start_date->format('M d') }} - {{ $campaign->end_date->format('M d, Y') }}</h5>
                        </div>
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Budget</p>
                            <h5 class="mb-0">AED {{ number_format($campaign->budget, 2) }}</h5>
                        </div>
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Business</p>
                            <h5 class="mb-0">{{ $campaign->business->name ?? 'N/A' }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Campaign Details & Performance Tabs -->
    <div class="row mb-4">
        <div class="col-md-12">
            <ul class="nav nav-tabs mb-3" id="campaignTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="details-tab" data-bs-toggle="tab" data-bs-target="#details" type="button" role="tab" aria-controls="details" aria-selected="true">
                        <i class="fas fa-info-circle me-2"></i> Details
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="preview-tab" data-bs-toggle="tab" data-bs-target="#preview" type="button" role="tab" aria-controls="preview" aria-selected="false">
                        <i class="fas fa-image me-2"></i> Banner Preview
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="performance-tab" data-bs-toggle="tab" data-bs-target="#performance" type="button" role="tab" aria-controls="performance" aria-selected="false">
                        <i class="fas fa-chart-bar me-2"></i> Performance
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="campaignTabContent">
                <!-- Details Tab -->
                <div class="tab-pane fade show active" id="details" role="tabpanel" aria-labelledby="details-tab">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <p class="text-muted mb-1">Campaign Title</p>
                                    <h5>{{ $campaign->name }}</h5>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <p class="text-muted mb-1">Description</p>
                                    <p>{{ $campaign->description ?? 'No description provided' }}</p>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Target Venue</p>
                                    <p>{{ $campaign->targeting_options['venue_id'] ? ($campaign->venue->name ?? 'N/A') : 'All Venues' }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Target Offer</p>
                                    <p>{{ $campaign->targeting_options['offer_id'] ? ($campaign->offer->name ?? 'N/A') : 'All Offers' }}</p>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Start Date</p>
                                    <p>{{ $campaign->start_date->format('M d, Y H:i') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">End Date</p>
                                    <p>{{ $campaign->end_date->format('M d, Y H:i') }}</p>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Created By</p>
                                    <p>{{ $campaign->approver->first_name ?? 'System' }} {{ $campaign->approver->last_name ?? '' }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Created At</p>
                                    <p>{{ $campaign->created_at->format('M d, Y H:i') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Banner Preview Tab -->
                <div class="tab-pane fade" id="preview" role="tabpanel" aria-labelledby="preview-tab">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="mb-3">Banner Preview</h5>

                            @if($campaign->banner_image)
                            <div class="text-center mb-3">
                                <img src="{{ asset('storage/' . $campaign->banner_image) }}"
                                     alt="Banner Image"
                                     class="img-fluid"
                                     style="max-height: 300px; border-radius: 8px;">
                            </div>
                            @else
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> No banner image uploaded yet
                            </div>
                            @endif

                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Banner Title (What users see)</p>
                                    <h6 class="bg-light p-3 rounded">{{ $campaign->name }}</h6>
                                </div>
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Banner Description</p>
                                    <p class="bg-light p-3 rounded">{{ $campaign->description ?? 'No description' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Performance Tab -->
                <div class="tab-pane fade" id="performance" role="tabpanel" aria-labelledby="performance-tab">
                    <div class="card">
                        <div class="card-body">
                            @if($aggregatedStats)
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ $aggregatedStats['total_impressions'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Impressions</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ $aggregatedStats['total_clicks'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Clicks</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ $aggregatedStats['total_conversions'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Conversions</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ round($aggregatedStats['average_ctr'] ?? 0, 2) }}%</h3>
                                        <p class="text-muted mb-0">Click-through Rate</p>
                                    </div>
                                </div>
                            </div>
                            @else
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> No performance data available yet
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Campaign Actions -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="mb-3">Campaign Actions</h5>
                    <div class="btn-group" role="group">
                        <a href="{{ route('admin.marketing.campaigns.edit', $campaign->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit me-2"></i> Edit Campaign
                        </a>

                        @if($campaign->status === 'pending')
                        <button type="button" class="btn btn-success" onclick="approveCampaign({{ $campaign->id }})">
                            <i class="fas fa-check me-2"></i> Approve
                        </button>
                        <button type="button" class="btn btn-danger" onclick="rejectCampaign({{ $campaign->id }})">
                            <i class="fas fa-times me-2"></i> Reject
                        </button>
                        @elseif($campaign->status === 'active' || $campaign->status === 'approved')
                        <button type="button" class="btn btn-warning" onclick="deactivateCampaign({{ $campaign->id }})">
                            <i class="fas fa-pause me-2"></i> Deactivate
                        </button>
                        @endif

                        <a href="{{ route('admin.marketing.campaigns') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function approveCampaign(campaignId) {
    if (confirm('Approve this campaign?')) {
        fetch(`/admin/marketing/campaigns/${campaignId}/approve`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({})
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign approved!');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to approve'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}

function rejectCampaign(campaignId) {
    const reason = prompt('Enter rejection reason:');
    if (!reason) return;

    fetch(`/admin/marketing/campaigns/${campaignId}/reject`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ reason: reason })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Campaign rejected!');
            location.reload();
        } else {
            alert('Error: ' + (data.message || 'Failed to reject'));
        }
    })
    .catch(error => alert('Error: ' + error.message));
}

function deactivateCampaign(campaignId) {
    const reason = prompt('Enter reason for deactivation:');
    if (!reason) return;

    fetch(`/admin/marketing/campaigns/${campaignId}/deactivate`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ reason: reason })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Campaign deactivated!');
            location.reload();
        } else {
            alert('Error: ' + (data.message || 'Failed to deactivate'));
        }
    })
    .catch(error => alert('Error: ' + error.message));
}
</script>
@endsection

