@extends('layouts.admin')

@section('title', 'Edit Email Template')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Edit Email Template</h1>
            <p class="text-muted">{{ $emailTemplate->name ?? 'N/A' }}</p>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.notifications.email-templates.update', $emailTemplate->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Template Name</label>
                                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                       value="{{ old('name', $emailTemplate->name ?? '') }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Slug</label>
                                <input type="text" name="slug" class="form-control"
                                       value="{{ $emailTemplate->slug ?? 'N/A' }}" disabled>
                                <small class="text-muted">Slug cannot be changed</small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Category</label>
                                <input type="text" name="category" class="form-control @error('category') is-invalid @enderror"
                                       value="{{ old('category', $emailTemplate->category ?? '') }}" required>
                                @error('category')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status</label>
                                <select name="is_active" class="form-select">
                                    <option value="1" {{ (old('is_active', $emailTemplate->is_active ?? false)) ? 'selected' : '' }}>Active</option>
                                    <option value="0" {{ !(old('is_active', $emailTemplate->is_active ?? false)) ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Subject</label>
                            <input type="text" name="subject" class="form-control @error('subject') is-invalid @enderror"
                                   value="{{ old('subject', $emailTemplate->subject ?? '') }}" required>
                            @error('subject')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <ul class="nav nav-tabs mb-3">
                            <li class="nav-item">
                                <a class="nav-link active" data-bs-toggle="tab" href="#htmlTab">HTML Body</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#plainTab">Plain Text Body</a>
                            </li>
                        </ul>

                        <div class="tab-content mb-3">
                            <div id="htmlTab" class="tab-pane fade show active">
                                <label class="form-label">HTML Content</label>
                                <textarea name="html_body" class="form-control @error('html_body') is-invalid @enderror"
                                          rows="8">{{ old('html_body', $emailTemplate->html_body ?? '') }}</textarea>
                                @error('html_body')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div id="plainTab" class="tab-pane fade">
                                <label class="form-label">Plain Text Content</label>
                                <textarea name="plain_text_body" class="form-control"
                                          rows="8">{{ old('plain_text_body', $emailTemplate->plain_text_body ?? '') }}</textarea>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Available Variables</label>
                            <small class="d-block mb-2 text-muted">Use these variables in your template:</small>
                            <code class="d-block p-2 bg-light rounded">{{ '{{ user.name }}, {{ user.email }}, {{ app.name }}, {{ url }}' }}</code>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Update Template
                            </button>
                            <a href="{{ route('admin.notifications.email-templates.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

