@extends('layouts.admin')

@section('title', 'Admin Notifications')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-bell"></i> Admin Notifications
            </h1>
            <p class="text-muted">Manage your system notifications</p>
        </div>
        <div class="col-md-4 text-end">
            @if(isset($unreadCount) && $unreadCount > 0)
                <button class="btn btn-sm btn-primary" id="markAllRead">
                    <i class="bi bi-check2-all"></i> Mark All Read ({{ $unreadCount }})
                </button>
            @endif
        </div>
    </div>

    <!-- Notification Cards -->
    <div class="row">
        @forelse($notifications as $notification)
        <div class="col-md-6 mb-3">
            <div class="card border-0 shadow-sm {{ !$notification->read_at ? 'border-left border-primary' : '' }}">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="flex-grow-1">
                            <!-- Notification Type Icon -->
                            <div class="mb-2">
                                @switch($notification->type)
                                    @case('business_verified')
                                        <span class="badge bg-success">Business Verified</span>
                                        @break
                                    @case('business_rejected')
                                        <span class="badge bg-danger">Business Rejected</span>
                                        @break
                                    @case('venue_approved')
                                        <span class="badge bg-success">Venue Approved</span>
                                        @break
                                    @case('venue_rejected')
                                        <span class="badge bg-danger">Venue Rejected</span>
                                        @break
                                    @case('staff_invited')
                                        <span class="badge bg-info">Staff Invited</span>
                                        @break
                                    @case('staff_joined')
                                        <span class="badge bg-success">Staff Joined</span>
                                        @break
                                    @case('payment_received')
                                        <span class="badge bg-success">Payment Received</span>
                                        @break
                                    @case('subscription_expiring')
                                        <span class="badge bg-warning">Subscription Expiring</span>
                                        @break
                                    @default
                                        <span class="badge bg-secondary">{{ ucfirst(str_replace('_', ' ', $notification->type)) }}</span>
                                @endswitch
                            </div>

                            <!-- Notification Content -->
                            @php
                                $data = $notification->data;
                            @endphp

                            <h6 class="mb-2 fw-bold">
                                @switch($notification->type)
                                    @case('business_verified')
                                        {{ $data['business_name'] ?? 'Unknown' }} - Verified
                                        @break
                                    @case('business_rejected')
                                        {{ $data['business_name'] ?? 'Unknown' }} - Rejected
                                        @break
                                    @case('venue_approved')
                                        {{ $data['venue_name'] ?? 'Unknown' }} - Approved
                                        @break
                                    @case('venue_rejected')
                                        {{ $data['venue_name'] ?? 'Unknown' }} - Rejected
                                        @break
                                    @case('staff_invited')
                                        New Staff Invite: {{ $data['staff_email'] ?? 'Unknown' }}
                                        @break
                                    @case('staff_joined')
                                        {{ $data['staff_name'] ?? 'Unknown' }} Joined {{ $data['business_name'] ?? 'Business' }}
                                        @break
                                    @case('payment_received')
                                        Payment Received: {{ $data['amount'] ?? '0' }}
                                        @break
                                    @case('subscription_expiring')
                                        Subscription Expiring: {{ $data['business_name'] ?? 'Unknown' }}
                                        @break
                                    @default
                                        {{ ucfirst(str_replace('_', ' ', $notification->type)) }}
                                @endswitch
                            </h6>

                            <!-- Notification Details -->
                            <p class="mb-2 text-muted small">
                                @switch($notification->type)
                                    @case('business_rejected')
                                        Reason: {{ $data['reason'] ?? 'No reason provided' }}
                                        @break
                                    @case('venue_rejected')
                                        Reason: {{ $data['reason'] ?? 'No reason provided' }}
                                        @break
                                    @case('payment_received')
                                        Amount: {{ $data['amount'] ?? 'N/A' }} {{ $data['currency'] ?? 'AED' }}
                                        @break
                                    @case('subscription_expiring')
                                        Expires: {{ $data['expiry_date'] ?? 'Unknown' }}
                                        @break
                                    @default
                                @endswitch
                            </p>

                            <!-- Timestamp -->
                            <small class="text-muted">
                                <i class="bi bi-clock"></i> {{ $notification->created_at->diffForHumans() }}
                            </small>
                        </div>

                        <!-- Actions -->
                        <div class="ms-3">
                            @if(!$notification->read_at)
                            <button class="btn btn-sm btn-light" onclick="markAsRead('{{ $notification->id }}')">
                                <i class="bi bi-check"></i>
                            </button>
                            @endif
                            <button class="btn btn-sm btn-light" onclick="deleteNotification('{{ $notification->id }}')">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Action Link -->
                    @if(!empty($data['action_url']))
                    <div class="mt-3">
                        <a href="{{ $data['action_url'] }}" class="btn btn-sm btn-outline-primary">
                            View Details <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @empty
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc;"></i>
                    <p class="text-muted mt-3">No notifications</p>
                </div>
            </div>
        </div>
        @endforelse
    </div>

    <!-- Pagination -->
    @if($notifications->hasPages())
    <nav class="mt-4">
        {{ $notifications->links() }}
    </nav>
    @endif
</div>

<script>
    function markAsRead(id) {
        fetch(`{{ route('admin.notifications.mark-read', '') }}/${id}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    }

    function deleteNotification(id) {
        if (confirm('Delete this notification?')) {
            fetch(`{{ route('admin.notifications.destroy', '') }}/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json'
                }
            }).then(response => {
                if (response.ok) {
                    location.reload();
                }
            });
        }
    }

    document.getElementById('markAllRead')?.addEventListener('click', function() {
        fetch(`{{ route('admin.notifications.mark-all-read') }}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    });
</script>

<style>
    .border-left {
        border-left: 3px solid !important;
    }
</style>
@endsection

