@extends('layouts.admin')

@section('title', 'SMS Templates')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-comment"></i> SMS Templates
            </h1>
            <p class="text-muted">Manage system SMS notification templates</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.notifications.sms-templates.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Template
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search templates..." value="{{ request('search') }}">
                </div>
                @if(isset($categories))
                <div class="col-md-3">
                    <select name="category" class="form-select form-select-sm">
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category }}" {{ request('category') === $category ? 'selected' : '' }}>
                                {{ ucfirst($category) }}
                            </option>
                        @endforeach
                    </select>
                </div>
                @endif
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
                <div class="col-md-2">
                    <a href="{{ route('admin.notifications.sms-templates.index') }}" class="btn btn-secondary btn-sm w-100">
                        <i class="fas fa-sync"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Templates Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Template Name</th>
                        <th>Slug</th>
                        <th>Category</th>
                        <th>Message</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($templates))
                    @forelse($templates as $template)
                    <tr>
                        <td>
                            <strong>{{ $template->name ?? 'N/A' }}</strong>
                        </td>
                        <td>
                            <code class="small">{{ $template->slug ?? 'N/A' }}</code>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($template->category ?? 'general') }}</span>
                        </td>
                        <td>
                            <span class="text-muted">{{ Str::limit($template->message ?? '', 50) }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ ($template->is_active ?? false) ? 'success' : 'secondary' }}">
                                {{ ($template->is_active ?? false) ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>
                            <small>{{ $template->created_at ? $template->created_at->format('M d, Y') : 'N/A' }}</small>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.notifications.sms-templates.edit', $template->id) }}" class="btn btn-primary" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button class="btn btn-info" onclick="previewTemplate({{ $template->id }})" title="Preview">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <form action="{{ route('admin.notifications.sms-templates.destroy', $template->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            No SMS templates found.
                        </td>
                    </tr>
                    @endforelse
                    @else
                    <tr>
                        <td colspan="7" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load templates
                        </td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if(isset($templates) && method_exists($templates, 'hasPages') && $templates->hasPages())
    <div class="d-flex justify-content-center mt-4">
        {{ $templates->links() }}
    </div>
    @endif
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Template Preview</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="previewContent">
                Loading...
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function previewTemplate(id) {
    const modal = new bootstrap.Modal(document.getElementById('previewModal'));
    fetch(`{{ route('admin.notifications.sms-templates.show', '') }}/${id}`, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.text())
    .then(html => {
        document.getElementById('previewContent').innerHTML = html;
        modal.show();
    });
}
</script>
@endpush
@endsection

