@extends('layouts.admin')

@section('title', 'Permissions Management')

@section('content')
    <div class="container-fluid">
        <div class="admin-header mb-4">
            <div>
                <h2>Permissions Management</h2>
                <p class="text-muted mb-0">Manage system permissions and access controls</p>
            </div>
            <a href="{{ route('admin.permissions.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle me-2"></i>Create New Permission
            </a>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- Stats -->
        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <div class="stat-icon bg-primary bg-opacity-10 text-primary">
                                    <i class="bi bi-shield-check"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <div class="text-muted small">Total Permissions</div>
                                <h3 class="mb-0">{{ $stats['total'] ?? 0 }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <div class="stat-icon bg-success bg-opacity-10 text-success">
                                    <i class="bi bi-folder"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <div class="text-muted small">Permission Groups</div>
                                <h3 class="mb-0">{{ $stats['groups'] ?? 0 }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter Tabs -->
        <ul class="nav nav-tabs mb-4">
            <li class="nav-item">
                <a class="nav-link {{ (isset($group) && $group === 'all') ? 'active' : '' }}" href="{{ route('admin.permissions.index', ['group' => 'all']) }}">
                    All Permissions
                </a>
            </li>
            @if(isset($groups))
            @foreach($groups as $grp)
                <li class="nav-item">
                    <a class="nav-link {{ (isset($group) && $group === $grp) ? 'active' : '' }}" href="{{ route('admin.permissions.index', ['group' => $grp]) }}">
                        {{ ucfirst($grp) }}
                    </a>
                </li>
            @endforeach
            @endif
        </ul>

        <!-- Permissions Table -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                        <tr>
                            <th>Permission Name</th>
                            <th>Group</th>
                            <th>Description</th>
                            <th>Roles</th>
                            <th class="text-end">Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if(isset($permissions))
                        @forelse($permissions as $permission)
                            <tr>
                                <td>
                                    <div>
                                        <strong>{{ $permission->display_name ?? 'N/A' }}</strong>
                                        <br><code class="small">{{ $permission->name ?? 'N/A' }}</code>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ ucfirst($permission->group ?? 'default') }}</span>
                                </td>
                                <td>
                                    <span class="text-muted">{{ Str::limit($permission->description ?? 'No description', 60) }}</span>
                                </td>
                                <td>
                                    @php
                                        $roleCount = isset($permission->roles) ? $permission->roles->count() : 0;
                                    @endphp
                                    @if(Route::has('admin.roles.show'))
                                        <a href="{{ route('admin.roles.show', $permission->id) }}" class="text-decoration-none">
                                            {{ $roleCount }} roles
                                        </a>
                                    @else
                                        <span class="text-muted">{{ $roleCount }} roles</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex justify-content-end gap-2">
                                        @if(Route::has('admin.permissions.edit'))
                                        <a href="{{ route('admin.permissions.edit', $permission->id) }}" class="btn btn-sm btn-primary" title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @endif
                                        <button onclick="deletePermission({{ $permission->id }}, '{{ $permission->display_name ?? 'Permission' }}')" class="btn btn-sm btn-danger" title="Delete">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <i class="bi bi-shield-x" style="font-size: 3rem; color: #ccc;"></i>
                                    <p class="text-muted mt-3">No permissions found</p>
                                </td>
                            </tr>
                        @endforelse
                        @else
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <i class="bi bi-exclamation-triangle" style="font-size: 3rem; color: #ccc;"></i>
                                    <p class="text-muted mt-3">Unable to load permissions</p>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>

                @if(isset($permissions) && $permissions->hasPages())
                    <div class="mt-4">
                        {{ $permissions->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <style>
        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
    </style>

    <script>
        function deletePermission(id, name) {
            if (!confirm(`Are you sure you want to delete the permission "${name}"?`)) {
                return;
            }

            fetch(`/admin/permissions/${id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.reload();
                    } else {
                        alert(data.message || 'Error deleting permission');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error deleting permission');
                });
        }
    </script>
@endsection
