@extends('layouts.admin')

@section('title', 'Manage Permissions: ' . $role->display_name)

@section('content')
<div class="admin-header mb-4">
    <div>
        <h2>Manage Permissions: {{ $role->display_name }}</h2>
        <p class="text-muted mb-0">Assign and manage permissions for this role</p>
    </div>
{{--    <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">--}}
{{--        <i class="bi bi-arrow-left"></i> Back to Role--}}
{{--    </a>--}}
</div>

<form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
    @csrf
    @method('PUT')

    <div class="row">
        <div class="col-lg-9">
            <!-- Permissions by Group -->
            @foreach($permissions as $group => $groupPermissions)
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">
                        {{ ucfirst(str_replace('_', ' ', $group)) }}
                        <span class="badge bg-secondary float-end">{{ count($groupPermissions) }} permissions</span>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($groupPermissions as $permission)
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_{{ $permission->id }}"
                                    name="permissions[]" value="{{ $permission->id }}"
                                    {{ in_array($permission->id, $rolePermissions) ? 'checked' : '' }}>
                                <label class="form-check-label" for="perm_{{ $permission->id }}">
                                    {{ $permission->display_name }}
                                    @if($permission->description)
                                        <small class="d-block text-muted">{{ $permission->description }}</small>
                                    @endif
                                </label>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endforeach

            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle"></i> Save Permissions
                </button>
                <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
                    <i class="bi bi-x-circle"></i> Cancel
                </a>
            </div>
        </div>

        <div class="col-lg-3">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Role Summary</h6>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-5">Name:</dt>
                        <dd class="col-sm-7"><strong>{{ $role->display_name }}</strong></dd>

                        <dt class="col-sm-5">Type:</dt>
                        <dd class="col-sm-7">
                            <span class="badge bg-{{ $role->type === 'admin' ? 'primary' : 'success' }}">
                                {{ ucfirst($role->type) }}
                            </span>
                        </dd>

                        <dt class="col-sm-5">System:</dt>
                        <dd class="col-sm-7">
                            @if($role->is_system)
                                <i class="bi bi-check-circle text-success"></i> Yes
                            @else
                                <i class="bi bi-x-circle text-danger"></i> No
                            @endif
                        </dd>

                        <dt class="col-sm-5">Permissions:</dt>
                        <dd class="col-sm-7">{{ count($rolePermissions) }} assigned</dd>

                        <dt class="col-sm-5">Users:</dt>
                        <dd class="col-sm-7">{{ $role->users()->count() }} users</dd>
                    </dl>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body text-center">
                    <button type="button" class="btn btn-sm btn-outline-secondary w-100" onclick="selectAll()">
                        <i class="bi bi-check-all"></i> Select All
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-secondary w-100 mt-2" onclick="deselectAll()">
                        <i class="bi bi-x"></i> Deselect All
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
function selectAll() {
    document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
        checkbox.checked = true;
    });
}

function deselectAll() {
    document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
        checkbox.checked = false;
    });
}
</script>

@endsection

