@extends('layouts.admin')

@section('title', 'Manage Permissions - ' . $role->display_name)

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-key"></i>
                {{ $role->display_name }} - Permissions
            </h1>
            <p class="text-muted mb-0">Manage permissions for this role</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Role
            </a>
        </div>
    </div>

    <!-- Role Info Card -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Role Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Role Name</label>
                        <p class="mb-0"><strong>{{ $role->display_name }}</strong></p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">System Role</label>
                        <p class="mb-0">
                            @if($role->is_system)
                                <span class="badge bg-warning">Yes</span>
                            @else
                                <span class="badge bg-success">No</span>
                            @endif
                        </p>
                    </div>
                    <div>
                        <label class="text-muted small">Total Permissions</label>
                        <p class="mb-0"><strong>{{ count($rolePermissions) }}</strong></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Stats</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="text-center">
                                <h4 class="mb-0">{{ count($rolePermissions) }}</h4>
                                <small class="text-muted">Assigned</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <h4 class="mb-0">{{ $permissions->sum(fn($group) => count($group)) }}</h4>
                                <small class="text-muted">Total Available</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <h4 class="mb-0">{{ $permissions->sum(fn($group) => count($group)) - count($rolePermissions) }}</h4>
                                <small class="text-muted">Not Assigned</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Permissions Management Form -->
    <form action="{{ route('admin.roles.sync-permissions', $role->id) }}" method="POST">
        @csrf

        <div class="row">
            @foreach($permissions as $group => $groupPermissions)
            <div class="col-lg-6 mb-4">
                <div class="card">
                    <div class="card-header bg-light">
                        <div class="form-check mb-0">
                            <input
                                class="form-check-input select-all-group"
                                type="checkbox"
                                id="group_{{ $loop->index }}"
                                data-group="{{ $group }}"
                            >
                            <label class="form-check-label fw-bold" for="group_{{ $loop->index }}">
                                {{ ucfirst(str_replace('_', ' ', $group)) }}
                                <span class="text-muted small">({{ count($groupPermissions) }})</span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="permission-group" data-group="{{ $group }}">
                            @foreach($groupPermissions as $permission)
                            <div class="form-check mb-3">
                                <input
                                    class="form-check-input permission-checkbox"
                                    type="checkbox"
                                    name="permissions[]"
                                    value="{{ $permission->id }}"
                                    id="permission_{{ $permission->id }}"
                                    data-group="{{ $group }}"
                                    {{ in_array($permission->id, $rolePermissions) ? 'checked' : '' }}
                                >
                                <label class="form-check-label" for="permission_{{ $permission->id }}">
                                    {{ $permission->name }}
                                    <br>
                                    <small class="text-muted">{{ $permission->description ?? 'No description' }}</small>
                                </label>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Action Buttons -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Changes
                            </button>
                            <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Select all checkboxes in a group
    document.querySelectorAll('.select-all-group').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const group = this.dataset.group;
            const permissionGroup = document.querySelector(`.permission-group[data-group="${group}"]`);
            const permissionCheckboxes = permissionGroup.querySelectorAll('input[type="checkbox"]');

            permissionCheckboxes.forEach(cb => {
                cb.checked = checkbox.checked;
            });
        });
    });

    // Update group checkbox when individual permissions change
    document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const group = this.dataset.group;
            const permissionGroup = document.querySelector(`.permission-group[data-group="${group}"]`);
            const permissionCheckboxes = permissionGroup.querySelectorAll('input[type="checkbox"]');
            const groupCheckbox = document.querySelector(`.select-all-group[data-group="${group}"]`);

            const allChecked = Array.from(permissionCheckboxes).every(cb => cb.checked);
            const someChecked = Array.from(permissionCheckboxes).some(cb => cb.checked);

            groupCheckbox.indeterminate = someChecked && !allChecked;
            groupCheckbox.checked = allChecked;
        });
    });
});
</script>
@endsection

