@extends('layouts.admin')

@section('title', 'Users with Role: ' . $role->display_name)

@section('content')
<div class="admin-header mb-4">
    <div>
        <h2>Users with Role: {{ $role->display_name }}</h2>
        <p class="text-muted mb-0">View all users assigned to this role</p>
    </div>
    <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back to Role
    </a>
</div>

<!-- Users Table -->
<div class="card">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Status</th>
                    <th>Assigned Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($users as $user)
                <tr>
                    <td>
                        <strong>{{ $user->first_name }} {{ $user->last_name }}</strong>
                    </td>
                    <td>{{ $user->email }}</td>
                    <td>
                        <span class="badge bg-{{ $user->status === 'active' ? 'success' : 'warning' }}">
                            {{ ucfirst($user->status) }}
                        </span>
                    </td>
                    <td>
                        @if($user->pivot->created_at)
                            {{ $user->pivot->created_at->format('M d, Y') }}
                        @else
                            N/A
                        @endif
                    </td>
                    <td>
                        <a href="{{ route('admin.users.show', $user->id) }}" class="btn btn-sm btn-light">
                            <i class="bi bi-eye"></i> View
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center py-5">
                        <i class="bi bi-people" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">No users assigned to this role</p>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($users->hasPages())
    <div class="card-footer bg-white">
        {{ $users->links() }}
    </div>
    @endif
</div>

@endsection

