@extends('layouts.admin')

@section('title', 'Create Spotlight')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-lightbulb"></i> Create New Spotlight
            </h1>
            <p class="text-muted mb-0">Add a new spotlight for an offer</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.spotlight.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <!-- Validation Errors -->
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Form -->
    <form action="{{ route('admin.spotlight.store') }}" method="POST" enctype="multipart/form-data" class="needs-validation">
        @csrf

        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Offer Selection -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Select Offer</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Offer <span class="text-danger">*</span></label>
                            <select name="offer_id" class="form-select @error('offer_id') is-invalid @enderror" required>
                                <option value="">-- Select an Offer --</option>
                                @foreach($offers as $offerItem)
                                    <option value="{{ $offerItem->id }}" {{ old('offer_id') == $offerItem->id ? 'selected' : '' }}>
                                        {{ $offerItem->title }} ({{ $offerItem->business->name ?? 'N/A' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('offer_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Content -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Spotlight Content</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Content <span class="text-danger">*</span></label>
                            <textarea
                                name="content"
                                class="form-control @error('content') is-invalid @enderror"
                                rows="5"
                                placeholder="Write your spotlight content here..."
                                required
                            >{{ old('content') }}</textarea>
                            @error('content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Describe the spotlight in detail</small>
                        </div>
                    </div>
                </div>

                <!-- Media -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Media</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Media Type</label>
                            <select name="media_type" class="form-select @error('media_type') is-invalid @enderror">
                                <option value="">-- Select Media Type --</option>
                                <option value="image" {{ old('media_type') == 'image' ? 'selected' : '' }}>Image</option>
                                <option value="video" {{ old('media_type') == 'video' ? 'selected' : '' }}>Video</option>
                                <option value="mixed" {{ old('media_type') == 'mixed' ? 'selected' : '' }}>Mixed</option>
                            </select>
                            @error('media_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Media URLs</label>
                            <div id="media-urls-container">
                                <div class="input-group mb-2">
                                    <input type="url" class="form-control" name="media_urls[]" placeholder="https://example.com/image.jpg">
                                    <button type="button" class="btn btn-outline-danger" onclick="this.parentElement.remove()">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="addMediaUrl()">
                                <i class="fas fa-plus"></i> Add URL
                            </button>
                            <small class="text-muted d-block mt-2">Add URLs for images or videos</small>
                        </div>
                    </div>
                </div>

                <!-- Location -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Location</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Location Name</label>
                            <input type="text" name="location" class="form-control @error('location') is-invalid @enderror" placeholder="e.g., Downtown Store" value="{{ old('location') }}">
                            @error('location')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Latitude</label>
                                    <input type="number" step="0.00000001" name="latitude" class="form-control @error('latitude') is-invalid @enderror" placeholder="e.g., 40.7128" value="{{ old('latitude') }}">
                                    @error('latitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Longitude</label>
                                    <input type="number" step="0.00000001" name="longitude" class="form-control @error('longitude') is-invalid @enderror" placeholder="e.g., -74.0060" value="{{ old('longitude') }}">
                                    @error('longitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Selected Offer Preview -->
                <div class="card mb-4 border-0 shadow-sm" id="offer-preview" style="display:none;">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Selected Offer</h5>
                    </div>
                    <div class="card-body">
                        <p id="offer-title" class="fw-bold mb-2">-</p>
                        <p id="offer-description" class="small text-muted mb-2">-</p>
                        <img id="offer-image" src="" class="img-fluid rounded mb-2" style="display:none;">
                    </div>
                </div>

                <!-- Submit Card -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Create Spotlight</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted small">
                            <i class="fas fa-info-circle"></i>
                            This spotlight will be created with "Pending" status and requires moderation approval.
                        </p>
                    </div>
                    <div class="card-footer bg-white">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-save"></i> Create Spotlight
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
function addMediaUrl() {
    const container = document.getElementById('media-urls-container');
    const div = document.createElement('div');
    div.className = 'input-group mb-2';
    div.innerHTML = `
        <input type="url" class="form-control" name="media_urls[]" placeholder="https://example.com/image.jpg">
        <button type="button" class="btn btn-outline-danger" onclick="this.parentElement.remove()">
            <i class="fas fa-times"></i>
        </button>
    `;
    container.appendChild(div);
}

document.querySelector('select[name="offer_id"]').addEventListener('change', function() {
    const offerId = this.value;
    if (offerId) {
        // Here you can load offer details via AJAX if needed
        document.getElementById('offer-preview').style.display = 'block';
    } else {
        document.getElementById('offer-preview').style.display = 'none';
    }
});
</script>
@endsection

