@extends('layouts.admin')

@section('title', 'Edit Spotlight')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-lightbulb"></i> Edit Spotlight
            </h1>
            <p class="text-muted mb-0">Update spotlight details</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.spotlight.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <!-- Validation Errors -->
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Form -->
    <form action="{{ route('admin.spotlight.update', $spotlight->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Offer Selection -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Associated Offer</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Offer <span class="text-danger">*</span></label>
                            <select name="offer_id" class="form-select @error('offer_id') is-invalid @enderror" required>
                                <option value="">-- Select an Offer --</option>
                                @foreach($offers as $offerItem)
                                    <option value="{{ $offerItem->id }}" {{ $spotlight->offer_id == $offerItem->id ? 'selected' : '' }}>
                                        {{ $offerItem->title }} ({{ $offerItem->business->name ?? 'N/A' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('offer_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Content -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Spotlight Content</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Content <span class="text-danger">*</span></label>
                            <textarea
                                name="content"
                                class="form-control @error('content') is-invalid @enderror"
                                rows="5"
                                required
                            >{{ old('content', $spotlight->content) }}</textarea>
                            @error('content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Describe the spotlight in detail</small>
                        </div>
                    </div>
                </div>

                <!-- Media -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Media</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Media Type</label>
                            <select name="media_type" class="form-select @error('media_type') is-invalid @enderror">
                                <option value="">-- Select Media Type --</option>
                                <option value="image" {{ old('media_type', $spotlight->media_type) == 'image' ? 'selected' : '' }}>Image</option>
                                <option value="video" {{ old('media_type', $spotlight->media_type) == 'video' ? 'selected' : '' }}>Video</option>
                                <option value="mixed" {{ old('media_type', $spotlight->media_type) == 'mixed' ? 'selected' : '' }}>Mixed</option>
                            </select>
                            @error('media_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Media URLs</label>
                            <div id="media-urls-container">
                                @if($spotlight->media_urls)
                                    @foreach($spotlight->media_urls as $url)
                                    <div class="input-group mb-2">
                                        <input type="url" class="form-control" name="media_urls[]" value="{{ $url }}">
                                        <button type="button" class="btn btn-outline-danger" onclick="this.parentElement.remove()">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                    @endforeach
                                @else
                                    <div class="input-group mb-2">
                                        <input type="url" class="form-control" name="media_urls[]" placeholder="https://example.com/image.jpg">
                                        <button type="button" class="btn btn-outline-danger" onclick="this.parentElement.remove()">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                @endif
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="addMediaUrl()">
                                <i class="fas fa-plus"></i> Add URL
                            </button>
                            <small class="text-muted d-block mt-2">Add URLs for images or videos</small>
                        </div>
                    </div>
                </div>

                <!-- Location -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Location</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Location Name</label>
                            <input type="text" name="location" class="form-control @error('location') is-invalid @enderror" value="{{ old('location', $spotlight->location) }}">
                            @error('location')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Latitude</label>
                                    <input type="number" step="0.00000001" name="latitude" class="form-control @error('latitude') is-invalid @enderror" value="{{ old('latitude', $spotlight->latitude) }}">
                                    @error('latitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Longitude</label>
                                    <input type="number" step="0.00000001" name="longitude" class="form-control @error('longitude') is-invalid @enderror" value="{{ old('longitude', $spotlight->longitude) }}">
                                    @error('longitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Status Card -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Status</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Moderation Status</label>
                            <div class="alert mb-0" role="alert">
                                @if($spotlight->moderation_status === 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @elseif($spotlight->moderation_status === 'rejected')
                                    <span class="badge bg-danger">Rejected</span>
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            </div>
                        </div>

                        @if($spotlight->moderation_notes)
                        <div class="mb-3">
                            <label class="form-label">Moderation Notes</label>
                            <p class="text-danger small">{{ $spotlight->moderation_notes }}</p>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Statistics Card -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Statistics</h5>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-6 mb-3">
                                <div class="text-muted small">Views</div>
                                <h4 class="mb-0">{{ $spotlight->view_count }}</h4>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="text-muted small">Likes</div>
                                <h4 class="mb-0">{{ $spotlight->likes_count }}</h4>
                            </div>
                            <div class="col-6">
                                <div class="text-muted small">Comments</div>
                                <h4 class="mb-0">{{ $spotlight->comments_count }}</h4>
                            </div>
                            <div class="col-6">
                                <div class="text-muted small">Shares</div>
                                <h4 class="mb-0">{{ $spotlight->shares_count }}</h4>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- User Info Card -->
                <div class="card mb-4 border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">User Info</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="avatar bg-light rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                    <i class="fas fa-user"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <p class="fw-bold mb-0">{{ $spotlight->user->first_name }} {{ $spotlight->user->last_name }}</p>
                                <small class="text-muted">{{ $spotlight->user->email }}</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-0">
                            <i class="far fa-calendar"></i>
                            Created: {{ $spotlight->created_at->format('M d, Y H:i') }}
                        </p>
                    </div>
                </div>

                <!-- Submit Card -->
                <div class="card border-0 shadow-sm">
                    <div class="card-footer bg-white">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-save"></i> Update Spotlight
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
function addMediaUrl() {
    const container = document.getElementById('media-urls-container');
    const div = document.createElement('div');
    div.className = 'input-group mb-2';
    div.innerHTML = `
        <input type="url" class="form-control" name="media_urls[]" placeholder="https://example.com/image.jpg">
        <button type="button" class="btn btn-outline-danger" onclick="this.parentElement.remove()">
            <i class="fas fa-times"></i>
        </button>
    `;
    container.appendChild(div);
}
</script>
@endsection

