@extends('layouts.admin')

@section('title', 'Spotlights Management')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-lightbulb"></i> Spotlights Management
            </h1>
            <p class="text-muted mb-0">Manage and moderate user spotlights</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.spotlight.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Spotlight
            </a>
        </div>
    </div>

    <!-- Success Message -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Statistics -->
    <div class="row mb-4 g-3">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Total Spotlights</p>
                            <h3 class="mb-0">{{ $stats['total'] }}</h3>
                        </div>
                        <div class="text-primary" style="font-size: 2rem;">
                            <i class="fas fa-lightbulb"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Pending</p>
                            <h3 class="mb-0">{{ $stats['pending'] }}</h3>
                        </div>
                        <div class="text-warning" style="font-size: 2rem;">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Approved</p>
                            <h3 class="mb-0">{{ $stats['approved'] }}</h3>
                        </div>
                        <div class="text-success" style="font-size: 2rem;">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Rejected</p>
                            <h3 class="mb-0">{{ $stats['rejected'] }}</h3>
                        </div>
                        <div class="text-danger" style="font-size: 2rem;">
                            <i class="fas fa-times-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select name="moderation" class="form-select">
                        <option value="all" {{ $moderation === 'all' ? 'selected' : '' }}>All</option>
                        <option value="pending" {{ $moderation === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="approved" {{ $moderation === 'approved' ? 'selected' : '' }}>Approved</option>
                        <option value="rejected" {{ $moderation === 'rejected' ? 'selected' : '' }}>Rejected</option>
                    </select>
                </div>
                <div class="col-md-9 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Spotlights Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Offer</th>
                        <th>Content</th>
                        <th>Media</th>
                        <th>Status</th>
                        <th>Likes</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($spotlights as $spotlight)
                    <tr>
                        <td>
                            <span class="badge bg-light text-dark">#{{ $spotlight->id }}</span>
                        </td>
                        <td>
                            <small>
                                <strong>{{ $spotlight->user->first_name ?? 'N/A' }}</strong><br>
                                <span class="text-muted">{{ $spotlight->user->email ?? '' }}</span>
                            </small>
                        </td>
                        <td>
                            @if($spotlight->offer)
                                <small>
                                    <a href="{{ route('admin.offers.show', $spotlight->offer->id) }}" class="text-decoration-none">
                                        {{ Str::limit($spotlight->offer->title, 30) }}
                                    </a>
                                </small>
                            @else
                                <span class="text-muted small">No Offer</span>
                            @endif
                        </td>
                        <td>
                            <small>{{ Str::limit($spotlight->content, 40) }}</small>
                        </td>
                        <td>
                            @if($spotlight->media_type)
                                <span class="badge bg-info">{{ ucfirst($spotlight->media_type) }}</span>
                            @else
                                <span class="text-muted small">-</span>
                            @endif
                        </td>
                        <td>
                            @if($spotlight->moderation_status === 'approved')
                                <span class="badge bg-success">Approved</span>
                            @elseif($spotlight->moderation_status === 'rejected')
                                <span class="badge bg-danger">Rejected</span>
                            @else
                                <span class="badge bg-warning">Pending</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-light text-dark">
                                <i class="fas fa-heart"></i> {{ $spotlight->likes_count }}
                            </span>
                        </td>
                        <td>
                            <small class="text-muted">{{ $spotlight->created_at->format('M d, Y') }}</small>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm" role="group">
                                <a href="{{ route('admin.spotlight.show', $spotlight->id) }}" class="btn btn-outline-primary" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.spotlight.edit', $spotlight->id) }}" class="btn btn-outline-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($spotlight->moderation_status !== 'approved')
                                <form action="{{ route('admin.spotlight.approve', $spotlight->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-outline-success btn-sm" title="Approve">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                @endif
                                @if($spotlight->moderation_status !== 'rejected')
                                <button type="button" class="btn btn-outline-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal{{ $spotlight->id }}" title="Reject">
                                    <i class="fas fa-times"></i>
                                </button>
                                @endif
                                <form action="{{ route('admin.spotlight.destroy', $spotlight->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline-dark btn-sm" title="Delete" onclick="return confirm('Are you sure?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>

                            <!-- Reject Modal -->
                            <div class="modal fade" id="rejectModal{{ $spotlight->id }}" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form action="{{ route('admin.spotlight.reject', $spotlight->id) }}" method="POST">
                                            @csrf
                                            <div class="modal-header">
                                                <h5 class="modal-title">Reject Spotlight</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="mb-3">
                                                    <label class="form-label">Rejection Notes</label>
                                                    <textarea name="moderation_notes" class="form-control" rows="3" placeholder="Why are you rejecting this spotlight?"></textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-danger">Reject</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            <i class="fas fa-inbox" style="font-size: 2rem;"></i>
                            <p class="mt-2">No spotlights found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-white">
            {{ $spotlights->links() }}
        </div>
    </div>
</div>
@endsection

