@extends('layouts.admin')

@section('title', 'Spotlights for ' . $offer->title)

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-lightbulb"></i> Spotlights for Offer
            </h1>
            <p class="text-muted mb-0">{{ $offer->title }}</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.spotlight.create', ['offer_id' => $offer->id]) }}" class="btn btn-primary me-2">
                <i class="fas fa-plus"></i> Add Spotlight
            </a>
            <a href="{{ route('admin.spotlight.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <!-- Offer Summary Card -->
    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-3">
                    @if($offer->featured_image)
                        <img src="{{ $offer->featured_image }}" class="img-fluid rounded" alt="{{ $offer->title }}">
                    @else
                        <div class="bg-light rounded d-flex align-items-center justify-content-center" style="height: 150px;">
                            <i class="fas fa-image fa-2x text-muted"></i>
                        </div>
                    @endif
                </div>
                <div class="col-md-9">
                    <h5>{{ $offer->title }}</h5>
                    <p class="text-muted">{{ Str::limit($offer->description, 200) }}</p>
                    <div class="row">
                        <div class="col-md-4">
                            <small class="text-muted">Business</small>
                            <p class="fw-bold mb-0">{{ $offer->business->name ?? 'N/A' }}</p>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">Status</small>
                            <p class="mb-0">
                                @if($offer->status === 'active')
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-warning">Inactive</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">Views</small>
                            <p class="fw-bold mb-0">{{ $offer->view_count }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Spotlights List -->
    @if(count($spotlights) > 0)
        <div class="row g-4">
            @foreach($spotlights as $spotlight)
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm h-100">
                    @if($spotlight->media_urls && count($spotlight->media_urls) > 0)
                        @php
                            $firstMedia = $spotlight->media_urls[0];
                            $isImage = Str::endsWith($firstMedia, ['.jpg', '.jpeg', '.png', '.gif', '.webp']);
                        @endphp
                        @if($isImage)
                            <img src="{{ $firstMedia }}" class="card-img-top" alt="Spotlight" style="height: 200px; object-fit: cover;">
                        @else
                            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                <i class="fas fa-image fa-2x text-muted"></i>
                            </div>
                        @endif
                    @else
                        <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                            <i class="fas fa-lightbulb fa-2x text-muted"></i>
                        </div>
                    @endif

                    <div class="card-body">
                        <h5 class="card-title">
                            By {{ $spotlight->user->first_name }} {{ $spotlight->user->last_name }}
                        </h5>
                        <p class="card-text text-muted small">{{ Str::limit($spotlight->content, 100) }}</p>

                        <div class="row text-center mb-3">
                            <div class="col-4">
                                <small class="text-muted">Views</small>
                                <p class="fw-bold mb-0">{{ $spotlight->view_count }}</p>
                            </div>
                            <div class="col-4">
                                <small class="text-muted">
                                    <i class="fas fa-heart"></i> Likes
                                </small>
                                <p class="fw-bold mb-0">{{ $spotlight->likes_count }}</p>
                            </div>
                            <div class="col-4">
                                <small class="text-muted">
                                    <i class="fas fa-comment"></i> Comments
                                </small>
                                <p class="fw-bold mb-0">{{ $spotlight->comments_count }}</p>
                            </div>
                        </div>

                        <div class="mb-3">
                            <span class="badge {{ $spotlight->moderation_status === 'approved' ? 'bg-success' : ($spotlight->moderation_status === 'rejected' ? 'bg-danger' : 'bg-warning') }}">
                                {{ ucfirst($spotlight->moderation_status) }}
                            </span>
                        </div>

                        <small class="text-muted d-block mb-3">
                            <i class="far fa-calendar"></i> {{ $spotlight->created_at->format('M d, Y') }}
                        </small>
                    </div>

                    <div class="card-footer bg-white border-top">
                        <div class="d-grid gap-2">
                            <a href="{{ route('admin.spotlight.show', $spotlight->id) }}" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i> View Details
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-4">
            {{ $spotlights->links() }}
        </div>
    @else
        <div class="card border-0 shadow-sm">
            <div class="card-body text-center py-5">
                <i class="fas fa-inbox" style="font-size: 3rem; color: #ccc;"></i>
                <h5 class="mt-3">No Spotlights Yet</h5>
                <p class="text-muted mb-3">This offer doesn't have any spotlights</p>
                <a href="{{ route('admin.spotlight.create', ['offer_id' => $offer->id]) }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Spotlight
                </a>
            </div>
        </div>
    @endif
</div>
@endsection
