@extends('layouts.admin')

@section('title', 'View Spotlight')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-lightbulb"></i> Spotlight Details
            </h1>
            <p class="text-muted mb-0">Review and moderate spotlight</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.spotlight.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <!-- Success Message -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Content Card -->
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-body">
                    <h4 class="card-title mb-3">Spotlight Content</h4>
                    <p class="card-text">{{ $spotlight->content }}</p>
                </div>
            </div>

            <!-- Media Card -->
            @if($spotlight->media_urls && count($spotlight->media_urls) > 0)
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Media</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        @foreach($spotlight->media_urls as $url)
                            @if(Str::endsWith($url, ['.jpg', '.jpeg', '.png', '.gif', '.webp']))
                                <div class="col-md-6">
                                    <img src="{{ $url }}" class="img-fluid rounded" alt="Spotlight Media">
                                </div>
                            @elseif(Str::endsWith($url, ['.mp4', '.webm', '.mov']))
                                <div class="col-md-6">
                                    <video class="w-100 rounded" controls style="max-height: 300px;">
                                        <source src="{{ $url }}">
                                        Your browser does not support the video tag.
                                    </video>
                                </div>
                            @else
                                <div class="col-md-6">
                                    <a href="{{ $url }}" class="btn btn-sm btn-outline-primary" target="_blank">
                                        <i class="fas fa-link"></i> {{ Str::limit($url, 40) }}
                                    </a>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
            @endif

            <!-- Location Card -->
            @if($spotlight->location || $spotlight->latitude)
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Location</h5>
                </div>
                <div class="card-body">
                    @if($spotlight->location)
                        <p class="mb-2">
                            <strong>{{ $spotlight->location }}</strong>
                        </p>
                    @endif
                    @if($spotlight->latitude && $spotlight->longitude)
                        <p class="text-muted small mb-0">
                            <i class="fas fa-map-marker-alt"></i>
                            {{ $spotlight->latitude }}, {{ $spotlight->longitude }}
                        </p>
                    @endif
                </div>
            </div>
            @endif

            <!-- Engagement Card -->
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Engagement</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="text-muted small mb-1">Views</div>
                            <h4 class="mb-0">{{ $spotlight->view_count }}</h4>
                        </div>
                        <div class="col-md-3">
                            <div class="text-muted small mb-1">
                                <i class="fas fa-heart text-danger"></i> Likes
                            </div>
                            <h4 class="mb-0">{{ $spotlight->likes_count }}</h4>
                        </div>
                        <div class="col-md-3">
                            <div class="text-muted small mb-1">
                                <i class="fas fa-comment"></i> Comments
                            </div>
                            <h4 class="mb-0">{{ $spotlight->comments_count }}</h4>
                        </div>
                        <div class="col-md-3">
                            <div class="text-muted small mb-1">
                                <i class="fas fa-share"></i> Shares
                            </div>
                            <h4 class="mb-0">{{ $spotlight->shares_count }}</h4>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Comments Section -->
            @if($spotlight->comments && count($spotlight->comments) > 0)
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Comments ({{ count($spotlight->comments) }})</h5>
                </div>
                <div class="card-body">
                    @foreach($spotlight->comments as $comment)
                    <div class="mb-3 pb-3 border-bottom">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="fw-bold mb-1">{{ $comment->user->first_name }} {{ $comment->user->last_name }}</p>
                                <p class="mb-2">{{ $comment->comment }}</p>
                                <small class="text-muted">{{ $comment->created_at->diffForHumans() }}</small>
                            </div>
                            <span class="badge bg-{{ $comment->status === 'active' ? 'success' : 'warning' }}">
                                {{ ucfirst($comment->status) }}
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Status Card -->
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Status & Moderation</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label small text-muted">Moderation Status</label>
                        <div>
                            @if($spotlight->moderation_status === 'approved')
                                <span class="badge bg-success" style="font-size: 0.9rem;">
                                    <i class="fas fa-check-circle"></i> Approved
                                </span>
                            @elseif($spotlight->moderation_status === 'rejected')
                                <span class="badge bg-danger" style="font-size: 0.9rem;">
                                    <i class="fas fa-times-circle"></i> Rejected
                                </span>
                            @else
                                <span class="badge bg-warning" style="font-size: 0.9rem;">
                                    <i class="fas fa-clock"></i> Pending
                                </span>
                            @endif
                        </div>
                    </div>

                    @if($spotlight->moderation_notes)
                    <div class="mb-3">
                        <label class="form-label small text-muted">Moderation Notes</label>
                        <p class="text-danger small mb-0">{{ $spotlight->moderation_notes }}</p>
                    </div>
                    @endif

                    @if($spotlight->moderated_at)
                    <div class="mb-0">
                        <label class="form-label small text-muted">Moderated At</label>
                        <p class="mb-0">
                            <small>
                                {{ $spotlight->moderated_at->format('M d, Y H:i') }}
                                @if($spotlight->moderator)
                                    <br>
                                    by {{ $spotlight->moderator->first_name }} {{ $spotlight->moderator->last_name }}
                                @endif
                            </small>
                        </p>
                    </div>
                    @endif
                </div>
                <div class="card-footer bg-white">
                    <div class="d-grid gap-2">
                        @if($spotlight->moderation_status !== 'approved')
                        <form action="{{ route('admin.spotlight.approve', $spotlight->id) }}" method="POST">
                            @csrf
                            <button type="submit" class="btn btn-success btn-sm w-100">
                                <i class="fas fa-check"></i> Approve
                            </button>
                        </form>
                        @endif

                        @if($spotlight->moderation_status !== 'rejected')
                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal">
                            <i class="fas fa-times"></i> Reject
                        </button>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Offer Card -->
            @if($spotlight->offer)
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Associated Offer</h5>
                </div>
                <div class="card-body">
                    <h6 class="card-title">{{ $spotlight->offer->title }}</h6>
                    <p class="card-text small text-muted">{{ Str::limit($spotlight->offer->description, 100) }}</p>
                    @if($spotlight->offer->featured_image)
                        <img src="{{ $spotlight->offer->featured_image }}" class="img-fluid rounded mb-2" alt="Offer Image">
                    @endif
                    <a href="{{ route('admin.offers.show', $spotlight->offer->id) }}" class="btn btn-sm btn-outline-primary w-100">
                        <i class="fas fa-eye"></i> View Offer
                    </a>
                </div>
            </div>
            @endif

            <!-- User Card -->
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">User Information</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar bg-light rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                            <i class="fas fa-user fa-lg"></i>
                        </div>
                        <div class="ms-3">
                            <p class="fw-bold mb-0">{{ $spotlight->user->first_name }} {{ $spotlight->user->last_name }}</p>
                            <small class="text-muted">{{ $spotlight->user->email }}</small>
                        </div>
                    </div>
                    <p class="mb-2">
                        <small>
                            <strong>Phone:</strong> {{ $spotlight->user->phone_number ?? 'N/A' }}
                        </small>
                    </p>
                    <p class="mb-0">
                        <small>
                            <strong>Member Since:</strong> {{ $spotlight->user->created_at->format('M d, Y') }}
                        </small>
                    </p>
                </div>
            </div>

            <!-- Timeline Card -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Timeline</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Created</small>
                        <p class="mb-0">{{ $spotlight->created_at->format('M d, Y H:i') }}</p>
                    </div>
                    <div>
                        <small class="text-muted">Last Updated</small>
                        <p class="mb-0">{{ $spotlight->updated_at->format('M d, Y H:i') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.spotlight.reject', $spotlight->id) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Reject Spotlight</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Rejection Notes <span class="text-danger">*</span></label>
                        <textarea name="moderation_notes" class="form-control" rows="4" placeholder="Explain why you're rejecting this spotlight..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject Spotlight</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

