@extends('layouts.admin')

@section('title', 'Business Staff Management')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-user-tie"></i> Business Staff
            </h1>
            <p class="text-muted">Manage all business staff members</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search staff..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="pending_invitation" {{ request('status') === 'pending_invitation' ? 'selected' : '' }}>Pending</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="role" class="form-select form-select-sm">
                        <option value="">All Roles</option>
                        <option value="owner" {{ request('role') === 'owner' ? 'selected' : '' }}>Owner</option>
                        <option value="manager" {{ request('role') === 'manager' ? 'selected' : '' }}>Manager</option>
                        <option value="staff" {{ request('role') === 'staff' ? 'selected' : '' }}>Staff</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="business_id" class="form-select form-select-sm">
                        <option value="">All Businesses</option>
                        @if(isset($businesses))
                        @foreach($businesses as $bid => $bname)
                            <option value="{{ $bid }}" {{ request('business_id') == $bid ? 'selected' : '' }}>
                                {{ $bname }}
                            </option>
                        @endforeach
                        @endif
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Staff</h6>
                    <h3 class="mb-0">{{ isset($staff) && method_exists($staff, 'total') ? $staff->total() : 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active</h6>
                    <h3 class="mb-0">{{ $stats['active'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Pending Invitations</h6>
                    <h3 class="mb-0">{{ $stats['pending'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">In Teams</h6>
                    <h3 class="mb-0">{{ $stats['in_teams'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Staff Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Business</th>
                        <th>Role</th>
                        <th>Team</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($staff))
                    @forelse($staff as $member)
                    <tr>
                        <td>
                            <strong>{{ $member->user->first_name ?? 'N/A' }} {{ $member->user->last_name ?? '' }}</strong>
                        </td>
                        <td>{{ $member->user->email ?? 'N/A' }}</td>
                        <td>
                            @if($member->business)
                            <a href="{{ route('admin.businesses.show', $member->business->id) }}">
                                {{ $member->business->business_name ?? 'N/A' }}
                            </a>
                            @else
                            <span class="text-muted">N/A</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-primary">{{ ucfirst($member->role ?? 'staff') }}</span>
                        </td>
                        <td>
                            @if($member->team)
                                <span class="badge bg-secondary">{{ $member->team->name ?? 'N/A' }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $member->status === 'active' ? 'success' : 'warning' }}">
                                {{ ucfirst(str_replace('_', ' ', $member->status ?? 'pending')) }}
                            </span>
                        </td>
                        <td>
                            @if($member->joined_at)
                                <small>{{ $member->joined_at->format('M d, Y') }}</small>
                            @else
                                <small class="text-muted">Pending</small>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('admin.staff.show', $member->id) }}" class="btn btn-sm btn-info" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.staff.edit', $member->id) }}" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No staff members found.
                        </td>
                    </tr>
                    @endforelse
                    @else
                    <tr>
                        <td colspan="8" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load staff data
                        </td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            @if(isset($staff) && method_exists($staff, 'firstItem'))
            Showing {{ $staff->firstItem() ?? 0 }} to {{ $staff->lastItem() ?? 0 }} of {{ $staff->total() }} staff members
            @else
            No data available
            @endif
        </div>
        <div>
            @if(isset($staff) && method_exists($staff, 'hasPages') && $staff->hasPages())
            {{ $staff->links() }}
            @endif
        </div>
    </div>
</div>
@endsection

